# state_tests.py - unit tests for store.py
# Copyright (C) 2008, 2009  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os
import tempfile
import unittest

import computerjanitorapp


class StateTests(unittest.TestCase):

    def setUp(self):
        self.state = computerjanitorapp.State()

    def testInitiallyEverythingIsEnabled(self):
        self.assert_(self.state.is_enabled("foo"))

    def testDisablesWhenAsked(self):
        self.state.disable("foo")
        self.assertFalse(self.state.is_enabled("foo"))

    def testEnablesDisabledCruft(self):
        self.state.disable("foo")
        self.state.enable("foo")
        self.assert_(self.state.is_enabled("foo"))

    def testEnablesEnabledCruft(self):
        self.state.enable("foo")
        self.assert_(self.state.is_enabled("foo"))

    def testSavesAndLoadsFiles(self):
        fd, filename = tempfile.mkstemp()
        os.close(fd)
        self.state.enable("foo")
        self.state.disable("bar")
        self.state.save(filename)
        self.state.disable("foo")
        self.state.enable("bar")
        self.state.load(filename)
        self.assert_(self.state.is_enabled("foo"))
        self.assertFalse(self.state.is_enabled("bar"))
        os.remove(filename)
