/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "wall_options.h"

static int WallOptionsDisplayPrivateIndex;

static CompMetadata wallOptionsMetadata;

static CompPluginVTable *wallPluginVTable = NULL;
CompPluginVTable wallOptionsVTable;

#define WALL_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, WallOptions, o)
#define WALL_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, WallOptions, o)

typedef struct _WallOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[WallDisplayOptionNum];
    wallDisplayOptionChangeNotifyProc notify[WallDisplayOptionNum];
} WallOptionsDisplay;

typedef struct _WallOptionsScreen
{
    CompOption opt[WallScreenOptionNum];
    wallScreenOptionChangeNotifyProc notify[WallScreenOptionNum];
} WallOptionsScreen;

Bool wallGetShowSwitcher (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionShowSwitcher].value.b;
}

CompOption * wallGetShowSwitcherOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionShowSwitcher];
}

void wallSetShowSwitcherNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionShowSwitcher] = notify;
}

Bool wallGetMiniscreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionMiniscreen].value.b;
}

CompOption * wallGetMiniscreenOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionMiniscreen];
}

void wallSetMiniscreenNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionMiniscreen] = notify;
}

float wallGetPreviewTimeout (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionPreviewTimeout].value.f;
}

CompOption * wallGetPreviewTimeoutOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionPreviewTimeout];
}

void wallSetPreviewTimeoutNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionPreviewTimeout] = notify;
}

int wallGetEdgeRadius (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionEdgeRadius].value.i;
}

CompOption * wallGetEdgeRadiusOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionEdgeRadius];
}

void wallSetEdgeRadiusNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionEdgeRadius] = notify;
}

unsigned short * wallGetOutlineColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionOutlineColor].value.c;
}

unsigned short wallGetOutlineColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionOutlineColor].value.c[0];
}

unsigned short wallGetOutlineColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionOutlineColor].value.c[1];
}

unsigned short wallGetOutlineColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionOutlineColor].value.c[2];
}

unsigned short wallGetOutlineColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionOutlineColor].value.c[3];
}

CompOption * wallGetOutlineColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionOutlineColor];
}

void wallSetOutlineColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionOutlineColor] = notify;
}

unsigned short * wallGetBackgroundGradientBaseColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientBaseColor].value.c;
}

unsigned short wallGetBackgroundGradientBaseColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientBaseColor].value.c[0];
}

unsigned short wallGetBackgroundGradientBaseColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientBaseColor].value.c[1];
}

unsigned short wallGetBackgroundGradientBaseColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientBaseColor].value.c[2];
}

unsigned short wallGetBackgroundGradientBaseColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientBaseColor].value.c[3];
}

CompOption * wallGetBackgroundGradientBaseColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionBackgroundGradientBaseColor];
}

void wallSetBackgroundGradientBaseColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionBackgroundGradientBaseColor] = notify;
}

unsigned short * wallGetBackgroundGradientHighlightColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientHighlightColor].value.c;
}

unsigned short wallGetBackgroundGradientHighlightColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientHighlightColor].value.c[0];
}

unsigned short wallGetBackgroundGradientHighlightColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientHighlightColor].value.c[1];
}

unsigned short wallGetBackgroundGradientHighlightColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientHighlightColor].value.c[2];
}

unsigned short wallGetBackgroundGradientHighlightColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientHighlightColor].value.c[3];
}

CompOption * wallGetBackgroundGradientHighlightColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionBackgroundGradientHighlightColor];
}

void wallSetBackgroundGradientHighlightColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionBackgroundGradientHighlightColor] = notify;
}

unsigned short * wallGetBackgroundGradientShadowColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientShadowColor].value.c;
}

unsigned short wallGetBackgroundGradientShadowColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientShadowColor].value.c[0];
}

unsigned short wallGetBackgroundGradientShadowColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientShadowColor].value.c[1];
}

unsigned short wallGetBackgroundGradientShadowColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientShadowColor].value.c[2];
}

unsigned short wallGetBackgroundGradientShadowColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionBackgroundGradientShadowColor].value.c[3];
}

CompOption * wallGetBackgroundGradientShadowColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionBackgroundGradientShadowColor];
}

void wallSetBackgroundGradientShadowColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionBackgroundGradientShadowColor] = notify;
}

unsigned short * wallGetThumbGradientBaseColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientBaseColor].value.c;
}

unsigned short wallGetThumbGradientBaseColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientBaseColor].value.c[0];
}

unsigned short wallGetThumbGradientBaseColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientBaseColor].value.c[1];
}

unsigned short wallGetThumbGradientBaseColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientBaseColor].value.c[2];
}

unsigned short wallGetThumbGradientBaseColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientBaseColor].value.c[3];
}

CompOption * wallGetThumbGradientBaseColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionThumbGradientBaseColor];
}

void wallSetThumbGradientBaseColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionThumbGradientBaseColor] = notify;
}

unsigned short * wallGetThumbGradientHighlightColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientHighlightColor].value.c;
}

unsigned short wallGetThumbGradientHighlightColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientHighlightColor].value.c[0];
}

unsigned short wallGetThumbGradientHighlightColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientHighlightColor].value.c[1];
}

unsigned short wallGetThumbGradientHighlightColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientHighlightColor].value.c[2];
}

unsigned short wallGetThumbGradientHighlightColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbGradientHighlightColor].value.c[3];
}

CompOption * wallGetThumbGradientHighlightColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionThumbGradientHighlightColor];
}

void wallSetThumbGradientHighlightColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionThumbGradientHighlightColor] = notify;
}

unsigned short * wallGetThumbHighlightGradientBaseColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientBaseColor].value.c;
}

unsigned short wallGetThumbHighlightGradientBaseColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientBaseColor].value.c[0];
}

unsigned short wallGetThumbHighlightGradientBaseColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientBaseColor].value.c[1];
}

unsigned short wallGetThumbHighlightGradientBaseColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientBaseColor].value.c[2];
}

unsigned short wallGetThumbHighlightGradientBaseColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientBaseColor].value.c[3];
}

CompOption * wallGetThumbHighlightGradientBaseColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionThumbHighlightGradientBaseColor];
}

void wallSetThumbHighlightGradientBaseColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionThumbHighlightGradientBaseColor] = notify;
}

unsigned short * wallGetThumbHighlightGradientShadowColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientShadowColor].value.c;
}

unsigned short wallGetThumbHighlightGradientShadowColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientShadowColor].value.c[0];
}

unsigned short wallGetThumbHighlightGradientShadowColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientShadowColor].value.c[1];
}

unsigned short wallGetThumbHighlightGradientShadowColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientShadowColor].value.c[2];
}

unsigned short wallGetThumbHighlightGradientShadowColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionThumbHighlightGradientShadowColor].value.c[3];
}

CompOption * wallGetThumbHighlightGradientShadowColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionThumbHighlightGradientShadowColor];
}

void wallSetThumbHighlightGradientShadowColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionThumbHighlightGradientShadowColor] = notify;
}

unsigned short * wallGetArrowBaseColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowBaseColor].value.c;
}

unsigned short wallGetArrowBaseColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowBaseColor].value.c[0];
}

unsigned short wallGetArrowBaseColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowBaseColor].value.c[1];
}

unsigned short wallGetArrowBaseColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowBaseColor].value.c[2];
}

unsigned short wallGetArrowBaseColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowBaseColor].value.c[3];
}

CompOption * wallGetArrowBaseColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionArrowBaseColor];
}

void wallSetArrowBaseColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionArrowBaseColor] = notify;
}

unsigned short * wallGetArrowShadowColor (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowShadowColor].value.c;
}

unsigned short wallGetArrowShadowColorRed (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowShadowColor].value.c[0];
}

unsigned short wallGetArrowShadowColorGreen (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowShadowColor].value.c[1];
}

unsigned short wallGetArrowShadowColorBlue (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowShadowColor].value.c[2];
}

unsigned short wallGetArrowShadowColorAlpha (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionArrowShadowColor].value.c[3];
}

CompOption * wallGetArrowShadowColorOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionArrowShadowColor];
}

void wallSetArrowShadowColorNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionArrowShadowColor] = notify;
}

Bool wallGetAllowWraparound (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionAllowWraparound].value.b;
}

CompOption * wallGetAllowWraparoundOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionAllowWraparound];
}

void wallSetAllowWraparoundNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionAllowWraparound] = notify;
}

float wallGetSlideDuration (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return od->opt[WallDisplayOptionSlideDuration].value.f;
}

CompOption * wallGetSlideDurationOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionSlideDuration];
}

void wallSetSlideDurationNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionSlideDuration] = notify;
}

CompAction * wallGetLeftKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftKey].value.action;
}

void wallSetLeftKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftKey].value.action.initiate = init;
}

void wallSetLeftKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftKey].value.action.terminate = term;
}

CompOption * wallGetLeftKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftKey];
}

void wallSetLeftKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionLeftKey] = notify;
}

CompAction * wallGetLeftButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftButton].value.action;
}

void wallSetLeftButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftButton].value.action.initiate = init;
}

void wallSetLeftButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftButton].value.action.terminate = term;
}

CompOption * wallGetLeftButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftButton];
}

void wallSetLeftButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionLeftButton] = notify;
}

CompAction * wallGetRightKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightKey].value.action;
}

void wallSetRightKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightKey].value.action.initiate = init;
}

void wallSetRightKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightKey].value.action.terminate = term;
}

CompOption * wallGetRightKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightKey];
}

void wallSetRightKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionRightKey] = notify;
}

CompAction * wallGetRightButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightButton].value.action;
}

void wallSetRightButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightButton].value.action.initiate = init;
}

void wallSetRightButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightButton].value.action.terminate = term;
}

CompOption * wallGetRightButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightButton];
}

void wallSetRightButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionRightButton] = notify;
}

CompAction * wallGetUpKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpKey].value.action;
}

void wallSetUpKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpKey].value.action.initiate = init;
}

void wallSetUpKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpKey].value.action.terminate = term;
}

CompOption * wallGetUpKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpKey];
}

void wallSetUpKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionUpKey] = notify;
}

CompAction * wallGetUpButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpButton].value.action;
}

void wallSetUpButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpButton].value.action.initiate = init;
}

void wallSetUpButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpButton].value.action.terminate = term;
}

CompOption * wallGetUpButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpButton];
}

void wallSetUpButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionUpButton] = notify;
}

CompAction * wallGetDownKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownKey].value.action;
}

void wallSetDownKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownKey].value.action.initiate = init;
}

void wallSetDownKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownKey].value.action.terminate = term;
}

CompOption * wallGetDownKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownKey];
}

void wallSetDownKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionDownKey] = notify;
}

CompAction * wallGetDownButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownButton].value.action;
}

void wallSetDownButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownButton].value.action.initiate = init;
}

void wallSetDownButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownButton].value.action.terminate = term;
}

CompOption * wallGetDownButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownButton];
}

void wallSetDownButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionDownButton] = notify;
}

CompAction * wallGetNextKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionNextKey].value.action;
}

void wallSetNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionNextKey].value.action.initiate = init;
}

void wallSetNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionNextKey].value.action.terminate = term;
}

CompOption * wallGetNextKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionNextKey];
}

void wallSetNextKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionNextKey] = notify;
}

CompAction * wallGetNextButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionNextButton].value.action;
}

void wallSetNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionNextButton].value.action.initiate = init;
}

void wallSetNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionNextButton].value.action.terminate = term;
}

CompOption * wallGetNextButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionNextButton];
}

void wallSetNextButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionNextButton] = notify;
}

CompAction * wallGetPrevKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionPrevKey].value.action;
}

void wallSetPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionPrevKey].value.action.initiate = init;
}

void wallSetPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionPrevKey].value.action.terminate = term;
}

CompOption * wallGetPrevKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionPrevKey];
}

void wallSetPrevKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionPrevKey] = notify;
}

CompAction * wallGetPrevButton (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionPrevButton].value.action;
}

void wallSetPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionPrevButton].value.action.initiate = init;
}

void wallSetPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionPrevButton].value.action.terminate = term;
}

CompOption * wallGetPrevButtonOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionPrevButton];
}

void wallSetPrevButtonNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionPrevButton] = notify;
}

CompAction * wallGetLeftWindowKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftWindowKey].value.action;
}

void wallSetLeftWindowKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftWindowKey].value.action.initiate = init;
}

void wallSetLeftWindowKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionLeftWindowKey].value.action.terminate = term;
}

CompOption * wallGetLeftWindowKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionLeftWindowKey];
}

void wallSetLeftWindowKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionLeftWindowKey] = notify;
}

CompAction * wallGetRightWindowKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightWindowKey].value.action;
}

void wallSetRightWindowKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightWindowKey].value.action.initiate = init;
}

void wallSetRightWindowKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionRightWindowKey].value.action.terminate = term;
}

CompOption * wallGetRightWindowKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionRightWindowKey];
}

void wallSetRightWindowKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionRightWindowKey] = notify;
}

CompAction * wallGetUpWindowKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpWindowKey].value.action;
}

void wallSetUpWindowKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpWindowKey].value.action.initiate = init;
}

void wallSetUpWindowKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionUpWindowKey].value.action.terminate = term;
}

CompOption * wallGetUpWindowKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionUpWindowKey];
}

void wallSetUpWindowKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionUpWindowKey] = notify;
}

CompAction * wallGetDownWindowKey (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownWindowKey].value.action;
}

void wallSetDownWindowKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownWindowKey].value.action.initiate = init;
}

void wallSetDownWindowKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionDownWindowKey].value.action.terminate = term;
}

CompOption * wallGetDownWindowKeyOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionDownWindowKey];
}

void wallSetDownWindowKeyNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionDownWindowKey] = notify;
}

CompAction * wallGetFlipLeftEdge (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipLeftEdge].value.action;
}

void wallSetFlipLeftEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipLeftEdge].value.action.initiate = init;
}

void wallSetFlipLeftEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipLeftEdge].value.action.terminate = term;
}

CompOption * wallGetFlipLeftEdgeOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipLeftEdge];
}

void wallSetFlipLeftEdgeNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionFlipLeftEdge] = notify;
}

CompAction * wallGetFlipRightEdge (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipRightEdge].value.action;
}

void wallSetFlipRightEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipRightEdge].value.action.initiate = init;
}

void wallSetFlipRightEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipRightEdge].value.action.terminate = term;
}

CompOption * wallGetFlipRightEdgeOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipRightEdge];
}

void wallSetFlipRightEdgeNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionFlipRightEdge] = notify;
}

CompAction * wallGetFlipUpEdge (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipUpEdge].value.action;
}

void wallSetFlipUpEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipUpEdge].value.action.initiate = init;
}

void wallSetFlipUpEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipUpEdge].value.action.terminate = term;
}

CompOption * wallGetFlipUpEdgeOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipUpEdge];
}

void wallSetFlipUpEdgeNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionFlipUpEdge] = notify;
}

CompAction * wallGetFlipDownEdge (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipDownEdge].value.action;
}

void wallSetFlipDownEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipDownEdge].value.action.initiate = init;
}

void wallSetFlipDownEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WALL_OPTIONS_DISPLAY(d);
    od->opt[WallDisplayOptionFlipDownEdge].value.action.terminate = term;
}

CompOption * wallGetFlipDownEdgeOption (CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[WallDisplayOptionFlipDownEdge];
}

void wallSetFlipDownEdgeNotify (CompDisplay *d, wallDisplayOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_DISPLAY(d);
    od->notify[WallDisplayOptionFlipDownEdge] = notify;
}

int wallGetMmmode (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return os->opt[WallScreenOptionMmmode].value.i;
}

CompOption * wallGetMmmodeOption (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return &os->opt[WallScreenOptionMmmode];
}

void wallSetMmmodeNotify (CompScreen *s, wallScreenOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_SCREEN(s);
    os->notify[WallScreenOptionMmmode] = notify;
}

Bool wallGetEdgeflipPointer (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return os->opt[WallScreenOptionEdgeflipPointer].value.b;
}

CompOption * wallGetEdgeflipPointerOption (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return &os->opt[WallScreenOptionEdgeflipPointer];
}

void wallSetEdgeflipPointerNotify (CompScreen *s, wallScreenOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_SCREEN(s);
    os->notify[WallScreenOptionEdgeflipPointer] = notify;
}

Bool wallGetEdgeflipMove (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return os->opt[WallScreenOptionEdgeflipMove].value.b;
}

CompOption * wallGetEdgeflipMoveOption (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return &os->opt[WallScreenOptionEdgeflipMove];
}

void wallSetEdgeflipMoveNotify (CompScreen *s, wallScreenOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_SCREEN(s);
    os->notify[WallScreenOptionEdgeflipMove] = notify;
}

Bool wallGetEdgeflipDnd (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return os->opt[WallScreenOptionEdgeflipDnd].value.b;
}

CompOption * wallGetEdgeflipDndOption (CompScreen *s)
{
    WALL_OPTIONS_SCREEN(s);
    return &os->opt[WallScreenOptionEdgeflipDnd];
}

void wallSetEdgeflipDndNotify (CompScreen *s, wallScreenOptionChangeNotifyProc notify)
{
    WALL_OPTIONS_SCREEN(s);
    os->notify[WallScreenOptionEdgeflipDnd] = notify;
}

CompOption * wallGetDisplayOption (CompDisplay *d, WallDisplayOptions num)
{
    WALL_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * wallGetScreenOption (CompScreen *s, WallScreenOptions num)
{
    WALL_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo wallOptionsDisplayOptionInfo[] = {
    { "show_switcher", "bool", 0, 0, 0 },
    { "miniscreen", "bool", 0, 0, 0 },
    { "preview_timeout", "float", "<min>0.0</min><max>2.0</max>", 0, 0 },
    { "edge_radius", "int", "<min>0</min><max>20</max>", 0, 0 },
    { "outline_color", "color", 0, 0, 0 },
    { "background_gradient_base_color", "color", 0, 0, 0 },
    { "background_gradient_highlight_color", "color", 0, 0, 0 },
    { "background_gradient_shadow_color", "color", 0, 0, 0 },
    { "thumb_gradient_base_color", "color", 0, 0, 0 },
    { "thumb_gradient_highlight_color", "color", 0, 0, 0 },
    { "thumb_highlight_gradient_base_color", "color", 0, 0, 0 },
    { "thumb_highlight_gradient_shadow_color", "color", 0, 0, 0 },
    { "arrow_base_color", "color", 0, 0, 0 },
    { "arrow_shadow_color", "color", 0, 0, 0 },
    { "allow_wraparound", "bool", 0, 0, 0 },
    { "slide_duration", "float", "<min>0.1</min><max>5.0</max>", 0, 0 },
    { "left_key", "key", 0, 0, 0 },
    { "left_button", "button", 0, 0, 0 },
    { "right_key", "key", 0, 0, 0 },
    { "right_button", "button", 0, 0, 0 },
    { "up_key", "key", 0, 0, 0 },
    { "up_button", "button", 0, 0, 0 },
    { "down_key", "key", 0, 0, 0 },
    { "down_button", "button", 0, 0, 0 },
    { "next_key", "key", 0, 0, 0 },
    { "next_button", "button", 0, 0, 0 },
    { "prev_key", "key", 0, 0, 0 },
    { "prev_button", "button", 0, 0, 0 },
    { "left_window_key", "key", 0, 0, 0 },
    { "right_window_key", "key", 0, 0, 0 },
    { "up_window_key", "key", 0, 0, 0 },
    { "down_window_key", "key", 0, 0, 0 },
    { "flip_left_edge", "edge", 0, 0, 0 },
    { "flip_right_edge", "edge", 0, 0, 0 },
    { "flip_up_edge", "edge", 0, 0, 0 },
    { "flip_down_edge", "edge", 0, 0, 0 },
};

static Bool wallOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    WALL_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, WallDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WallDisplayOptionShowSwitcher:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionShowSwitcher])
                (*od->notify[WallDisplayOptionShowSwitcher]) (d, o, WallDisplayOptionShowSwitcher);
            return TRUE;
        }
        break;
     case WallDisplayOptionMiniscreen:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionMiniscreen])
                (*od->notify[WallDisplayOptionMiniscreen]) (d, o, WallDisplayOptionMiniscreen);
            return TRUE;
        }
        break;
     case WallDisplayOptionPreviewTimeout:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionPreviewTimeout])
                (*od->notify[WallDisplayOptionPreviewTimeout]) (d, o, WallDisplayOptionPreviewTimeout);
            return TRUE;
        }
        break;
     case WallDisplayOptionEdgeRadius:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionEdgeRadius])
                (*od->notify[WallDisplayOptionEdgeRadius]) (d, o, WallDisplayOptionEdgeRadius);
            return TRUE;
        }
        break;
     case WallDisplayOptionOutlineColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionOutlineColor])
                (*od->notify[WallDisplayOptionOutlineColor]) (d, o, WallDisplayOptionOutlineColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionBackgroundGradientBaseColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionBackgroundGradientBaseColor])
                (*od->notify[WallDisplayOptionBackgroundGradientBaseColor]) (d, o, WallDisplayOptionBackgroundGradientBaseColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionBackgroundGradientHighlightColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionBackgroundGradientHighlightColor])
                (*od->notify[WallDisplayOptionBackgroundGradientHighlightColor]) (d, o, WallDisplayOptionBackgroundGradientHighlightColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionBackgroundGradientShadowColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionBackgroundGradientShadowColor])
                (*od->notify[WallDisplayOptionBackgroundGradientShadowColor]) (d, o, WallDisplayOptionBackgroundGradientShadowColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionThumbGradientBaseColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionThumbGradientBaseColor])
                (*od->notify[WallDisplayOptionThumbGradientBaseColor]) (d, o, WallDisplayOptionThumbGradientBaseColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionThumbGradientHighlightColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionThumbGradientHighlightColor])
                (*od->notify[WallDisplayOptionThumbGradientHighlightColor]) (d, o, WallDisplayOptionThumbGradientHighlightColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionThumbHighlightGradientBaseColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionThumbHighlightGradientBaseColor])
                (*od->notify[WallDisplayOptionThumbHighlightGradientBaseColor]) (d, o, WallDisplayOptionThumbHighlightGradientBaseColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionThumbHighlightGradientShadowColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionThumbHighlightGradientShadowColor])
                (*od->notify[WallDisplayOptionThumbHighlightGradientShadowColor]) (d, o, WallDisplayOptionThumbHighlightGradientShadowColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionArrowBaseColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionArrowBaseColor])
                (*od->notify[WallDisplayOptionArrowBaseColor]) (d, o, WallDisplayOptionArrowBaseColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionArrowShadowColor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionArrowShadowColor])
                (*od->notify[WallDisplayOptionArrowShadowColor]) (d, o, WallDisplayOptionArrowShadowColor);
            return TRUE;
        }
        break;
     case WallDisplayOptionAllowWraparound:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionAllowWraparound])
                (*od->notify[WallDisplayOptionAllowWraparound]) (d, o, WallDisplayOptionAllowWraparound);
            return TRUE;
        }
        break;
     case WallDisplayOptionSlideDuration:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionSlideDuration])
                (*od->notify[WallDisplayOptionSlideDuration]) (d, o, WallDisplayOptionSlideDuration);
            return TRUE;
        }
        break;
     case WallDisplayOptionLeftKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionLeftKey])
                (*od->notify[WallDisplayOptionLeftKey]) (d, o, WallDisplayOptionLeftKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionLeftButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionLeftButton])
                (*od->notify[WallDisplayOptionLeftButton]) (d, o, WallDisplayOptionLeftButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionRightKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionRightKey])
                (*od->notify[WallDisplayOptionRightKey]) (d, o, WallDisplayOptionRightKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionRightButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionRightButton])
                (*od->notify[WallDisplayOptionRightButton]) (d, o, WallDisplayOptionRightButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionUpKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionUpKey])
                (*od->notify[WallDisplayOptionUpKey]) (d, o, WallDisplayOptionUpKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionUpButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionUpButton])
                (*od->notify[WallDisplayOptionUpButton]) (d, o, WallDisplayOptionUpButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionDownKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionDownKey])
                (*od->notify[WallDisplayOptionDownKey]) (d, o, WallDisplayOptionDownKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionDownButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionDownButton])
                (*od->notify[WallDisplayOptionDownButton]) (d, o, WallDisplayOptionDownButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionNextKey])
                (*od->notify[WallDisplayOptionNextKey]) (d, o, WallDisplayOptionNextKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionNextButton])
                (*od->notify[WallDisplayOptionNextButton]) (d, o, WallDisplayOptionNextButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionPrevKey])
                (*od->notify[WallDisplayOptionPrevKey]) (d, o, WallDisplayOptionPrevKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionPrevButton])
                (*od->notify[WallDisplayOptionPrevButton]) (d, o, WallDisplayOptionPrevButton);
            return TRUE;
        }
        break;
     case WallDisplayOptionLeftWindowKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionLeftWindowKey])
                (*od->notify[WallDisplayOptionLeftWindowKey]) (d, o, WallDisplayOptionLeftWindowKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionRightWindowKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionRightWindowKey])
                (*od->notify[WallDisplayOptionRightWindowKey]) (d, o, WallDisplayOptionRightWindowKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionUpWindowKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionUpWindowKey])
                (*od->notify[WallDisplayOptionUpWindowKey]) (d, o, WallDisplayOptionUpWindowKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionDownWindowKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionDownWindowKey])
                (*od->notify[WallDisplayOptionDownWindowKey]) (d, o, WallDisplayOptionDownWindowKey);
            return TRUE;
        }
        break;
     case WallDisplayOptionFlipLeftEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionFlipLeftEdge])
                (*od->notify[WallDisplayOptionFlipLeftEdge]) (d, o, WallDisplayOptionFlipLeftEdge);
            return TRUE;
        }
        break;
     case WallDisplayOptionFlipRightEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionFlipRightEdge])
                (*od->notify[WallDisplayOptionFlipRightEdge]) (d, o, WallDisplayOptionFlipRightEdge);
            return TRUE;
        }
        break;
     case WallDisplayOptionFlipUpEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionFlipUpEdge])
                (*od->notify[WallDisplayOptionFlipUpEdge]) (d, o, WallDisplayOptionFlipUpEdge);
            return TRUE;
        }
        break;
     case WallDisplayOptionFlipDownEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WallDisplayOptionFlipDownEdge])
                (*od->notify[WallDisplayOptionFlipDownEdge]) (d, o, WallDisplayOptionFlipDownEdge);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * wallOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    WALL_OPTIONS_DISPLAY(d);
    *count = WallDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo wallOptionsScreenOptionInfo[] = {
    { "mmmode", "int", "<min>0</min><max>1</max>", 0, 0 },
    { "edgeflip_pointer", "bool", 0, 0, 0 },
    { "edgeflip_move", "bool", 0, 0, 0 },
    { "edgeflip_dnd", "bool", 0, 0, 0 },
};

static Bool wallOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    WALL_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, WallScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WallScreenOptionMmmode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallScreenOptionMmmode])
                (*os->notify[WallScreenOptionMmmode]) (s, o, WallScreenOptionMmmode);
            return TRUE;
        }
        break;
     case WallScreenOptionEdgeflipPointer:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallScreenOptionEdgeflipPointer])
                (*os->notify[WallScreenOptionEdgeflipPointer]) (s, o, WallScreenOptionEdgeflipPointer);
            return TRUE;
        }
        break;
     case WallScreenOptionEdgeflipMove:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallScreenOptionEdgeflipMove])
                (*os->notify[WallScreenOptionEdgeflipMove]) (s, o, WallScreenOptionEdgeflipMove);
            return TRUE;
        }
        break;
     case WallScreenOptionEdgeflipDnd:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WallScreenOptionEdgeflipDnd])
                (*os->notify[WallScreenOptionEdgeflipDnd]) (s, o, WallScreenOptionEdgeflipDnd);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * wallOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    WALL_OPTIONS_SCREEN(s);
    *count = WallScreenOptionNum;
    return os->opt;
}

static Bool wallOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    WallOptionsScreen *os;
    
    WALL_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(WallOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &wallOptionsMetadata, wallOptionsScreenOptionInfo, os->opt, WallScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void wallOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    WALL_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, WallScreenOptionNum);

    free (os);
}

static Bool wallOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    WallOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(WallOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[WallOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &wallOptionsMetadata, wallOptionsDisplayOptionInfo, od->opt, WallDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void wallOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    WALL_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, WallDisplayOptionNum);

    free (od);
}

static Bool wallOptionsInit (CompPlugin *p)
{
    WallOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (WallOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&wallOptionsMetadata, "wall",wallOptionsDisplayOptionInfo, WallDisplayOptionNum, wallOptionsScreenOptionInfo, WallScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&wallOptionsMetadata, "wall");
    if (wallPluginVTable && wallPluginVTable->init)
        return wallPluginVTable->init (p);
    return TRUE;
}

static void wallOptionsFini (CompPlugin *p)
{
    if (wallPluginVTable && wallPluginVTable->fini)
        wallPluginVTable->fini (p);

    if (WallOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (WallOptionsDisplayPrivateIndex);

    compFiniMetadata (&wallOptionsMetadata);
}

static CompBool wallOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) wallOptionsInitDisplay,
        (InitPluginObjectProc) wallOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void wallOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) wallOptionsFiniDisplay,
        (FiniPluginObjectProc) wallOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool wallOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = wallOptionsInitObject (p, o);
    if (wallPluginVTable->initObject)
        rv &= wallPluginVTable->initObject (p, o);
    return rv;
}

static void wallOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (wallPluginVTable->finiObject)
        wallPluginVTable->finiObject (p, o);
    wallOptionsFiniObject (p, o);
}

static CompOption * wallOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) wallOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) wallOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool wallOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) wallOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) wallOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
wallOptionsGetMetadata (CompPlugin *plugin)
{
    return &wallOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!wallPluginVTable)
    {
        wallPluginVTable = getCompPluginInfo ();
        memcpy(&wallOptionsVTable, wallPluginVTable, sizeof(CompPluginVTable));
        wallOptionsVTable.getMetadata = wallOptionsGetMetadata;
        wallOptionsVTable.init = wallOptionsInit;
        wallOptionsVTable.fini = wallOptionsFini;
        wallOptionsVTable.initObject = wallOptionsInitObjectWrapper;
        wallOptionsVTable.finiObject = wallOptionsFiniObjectWrapper;
        wallOptionsVTable.getObjectOptions = wallOptionsGetObjectOptions;
	wallOptionsVTable.setObjectOption = wallOptionsSetObjectOption;
	
    }
    return &wallOptionsVTable;
}

