/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _MBLUR_OPTIONS_H
#define _MBLUR_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    MblurDisplayOptionInitiateKey,
    MblurDisplayOptionNum
} MblurDisplayOptions;

typedef void (*mblurDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, MblurDisplayOptions num);

CompOption *mblurGetDisplayOption (CompDisplay *d, MblurDisplayOptions num);

typedef enum
{
    MblurScreenOptionMode,
    MblurScreenOptionStrength,
    MblurScreenOptionOnTransformedScreen,
    MblurScreenOptionNum
} MblurScreenOptions;

typedef void (*mblurScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, MblurScreenOptions num);

CompOption *mblurGetScreenOption (CompScreen *s, MblurScreenOptions num);

typedef enum
{
    ModeTextureCopy = 0,
    ModeAccumulationBuffer = 1,
} MblurModeEnum;

CompAction *     mblurGetInitiateKey (CompDisplay *d);
void             mblurSetInitiateKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             mblurSetInitiateKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     mblurGetInitiateKeyOption (CompDisplay *d);
void             mblurSetInitiateKeyNotify (CompDisplay *d, mblurDisplayOptionChangeNotifyProc notify);

int              mblurGetMode (CompScreen *s);
CompOption *     mblurGetModeOption (CompScreen *s);
void             mblurSetModeNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify);

float            mblurGetStrength (CompScreen *s);
CompOption *     mblurGetStrengthOption (CompScreen *s);
void             mblurSetStrengthNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify);

Bool             mblurGetOnTransformedScreen (CompScreen *s);
CompOption *     mblurGetOnTransformedScreenOption (CompScreen *s);
void             mblurSetOnTransformedScreenNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
