/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_RENDER_TARGET_H_
#define _CTK_RENDER_TARGET_H_

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define CTK_TYPE_RENDER_TARGET (ctk_render_target_get_type ())

typedef struct _CtkRenderTarget CtkRenderTarget;

typedef enum
{
  CTK_RENDER_TARGET_IN_USE = 1 << 0,
  CTK_RENDER_TARGET_STACKED = 1 << 1

} CtkRenderTargetFlags;

GType             ctk_render_target_get_type   (void) G_GNUC_CONST;

CtkRenderTarget * ctk_render_target_new        (void);

CtkRenderTarget * ctk_render_target_new_sized  (guint            width,
                                                guint            height);

void              ctk_render_target_resize     (CtkRenderTarget *self,
                                                guint            width,
                                                guint            height);

void              ctk_render_target_free       (CtkRenderTarget *self);

void              ctk_render_target_bind       (CtkRenderTarget *self);

void              ctk_render_target_unbind     (void);

guint             ctk_render_target_get_width  (CtkRenderTarget *self);

guint             ctk_render_target_get_height (CtkRenderTarget *self);

guint             ctk_render_target_get_depth_buffer_ogl_id (CtkRenderTarget *self);

guint             ctk_render_target_get_color_buffer_ogl_id (CtkRenderTarget *self);

guint             ctk_render_target_get_frame_buffer_ogl_id (CtkRenderTarget *self);

void              ctk_render_target_get_size   (CtkRenderTarget *self,
                                                guint           *width,
                                                guint           *height);

CtkRenderTargetFlags ctk_render_target_get_flags (CtkRenderTarget      *self);

void                 ctk_render_target_set_flags (CtkRenderTarget      *self,
                                                  CtkRenderTargetFlags  flags);

G_END_DECLS

#endif /* _CTK_RENDER_TARGET_H_ */

