/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_EFFECT_H_
#define _CTK_EFFECT_H_

#include <glib.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define CTK_EFFECT_MIN_MARGIN           0
#define CTK_EFFECT_MAX_MARGIN           100
#define CTK_EFFECT_DEFAULT_MARGIN       0

#define CTK_EFFECT_MIN_OPACITY          0.0f
#define CTK_EFFECT_MAX_OPACITY          1.0f
#define CTK_EFFECT_DEFAULT_OPACITY      1.0f

#define CTK_EFFECT_MIN_STRENGTH         0
#define CTK_EFFECT_MAX_STRENGTH         100
#define CTK_EFFECT_DEFAULT_STRENGTH     5

#define CTK_TYPE_EFFECT (ctk_effect_get_type ())

#define CTK_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_EFFECT, CtkEffect))

#define CTK_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_EFFECT, CtkEffectClass))

#define CTK_IS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_EFFECT))

#define CTK_IS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_EFFECT))

#define CTK_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_EFFECT, CtkEffectClass))

typedef struct _CtkEffect        CtkEffect;
typedef struct _CtkEffectClass   CtkEffectClass;
typedef struct _CtkEffectPrivate CtkEffectPrivate;

/**
 * ClutterEffectPaintFunc:
 * @actor: a #ClutterActor
 *
 * Paints @actor without having to go through #clutter_actor_paint]
 **/
typedef void (*CtkEffectPaintFunc) (ClutterActor *actor);

struct _CtkEffect
{
  GObject                  parent;

  /*< private >*/
  ClutterActor *_actor;
};

struct _CtkEffectClass
{
  GObjectClass   parent_class;

  /*< vtable, not signals >*/
  void (*paint) (CtkEffect *effect, CtkEffectPaintFunc func, gboolean is_last_effect);
  
  /*< private >*/
  void (*_view_padding1) (void);
  void (*_view_padding2) (void);
  void (*_view_padding3) (void);
  void (*_view_padding4) (void);
  void (*_view_padding5) (void);
  void (*_view_padding6) (void);
};

GType              ctk_effect_get_type      (void) G_GNUC_CONST;

void               ctk_effect_paint         (CtkEffect          *self,
                                             CtkEffectPaintFunc  func,
                                             gboolean            is_last_effect);

void               ctk_effect_set_actor     (CtkEffect          *self,
                                             ClutterActor       *actor);

ClutterActor     * ctk_effect_get_actor     (CtkEffect          *self);

ClutterAnimation * ctk_effect_animate       (CtkEffect          *self,
                                             gulong              mode,
                                             guint               duration,
                                             const gchar  *first_property_name,
                                             ...);

void               ctk_effect_set_margin    (CtkEffect          *self,
                                             gint               m);
gint               ctk_effect_get_margin    (CtkEffect          *self);

void               ctk_effect_set_opacity   (CtkEffect          *self,
                                             gfloat             m);
gfloat             ctk_effect_get_opacity   (CtkEffect          *self);

void               ctk_effect_set_strength  (CtkEffect *self,
                                             gint strength);

gint               ctk_effect_get_strength  (CtkEffect *self);

void               ctk_effect_set_invalidate_effect_cache (CtkEffect *self, gboolean dirty);

gboolean           ctk_effect_is_effect_cache_dirty (CtkEffect *self);

ClutterAnimation * ctk_effect_get_animation (CtkEffect          *self);

G_END_DECLS

#endif /* _CTK_EFFECT_H_ */

