/* Generated from posix.scm by the Chicken compiler
   2006-02-17 19:07
   Version 2, Build 228 - linux-unix-gnu-x86 - [ libffi dload ptables ]
   command line: posix.scm -quiet -no-trace -no-lambda-info -optimize-level 2 -unsafe -feature unsafe -include-path . -output-file uposix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef ECOS
#include <cyg/posix/signal.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else 
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
#ifndef ECOS
static C_TLS struct passwd *C_user;
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
#endif
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef ECOS
#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#endif
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

static void C_fcall C_free_exec_env() {
  char **a = C_exec_env;
  while((*a) != NULL) C_free(*(a++));
}

#define C_set_exec_arg(i, a, len)      C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)      C_set_arg_string(C_exec_env, i, a, len)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__CYGWIN__)
/* timegm code from Linux manpages */
time_t timegm (struct tm *tm)
{
   time_t ret;
   char *tz;

   tz = getenv("TZ");
   setenv("TZ", "", 1);
   tzset();
   ret = mktime(tm);
   if (tz)
      setenv("TZ", tz, 1);
   else
      unsetenv("TZ");
   tzset();
   return ret;
}
#endif

#if !defined(C_GNU_ENV) || defined(__CYGWIN__)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = timegm(&C_tm)) != -1)
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = timegm(&C_tm)) != -1)
#endif

#ifndef ECOS
static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))
#endif

static C_PTABLE_ENTRY *create_ptable(void);
C_externimport void C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[362];


/* from k4710 in set-root-directory! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub926(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub926(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from select */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub779(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub779(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from sleep in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub749(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub749(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub746(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub746(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub744(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub744(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub685(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub685(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k3850 */
static C_word C_fcall stub678(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub678(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub673(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub673(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k3842 */
static C_word C_fcall stub666(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub666(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f_3827 in k3821 in process-fork in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub654(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub654(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub649(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub649(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub612(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub612(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
              else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from ttyname */
static C_word C_fcall stub605(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub605(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub591(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub591(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub585(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub585(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub580(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub580(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#ifndef __CYGWIN__
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_return:
#undef return

return C_r;}

/* from asctime */
static C_word C_fcall stub565(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub565(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub556(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub556(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3384 */
static C_word C_fcall stub529(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub529(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k3326 */
static C_word C_fcall stub504(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub504(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub482(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k2808 in k2804 in file-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub380(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub380(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from current-effective-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub342(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub342(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub340(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub340(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub338(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub338(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub336(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub336(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2530 in initialize-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub314(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub314(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from _ensure-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub288(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub288(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from _get-groups */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub284(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub284(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from group-member */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub273(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub273(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from fd_test in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub65(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub65(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub59(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub59(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall stub54(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub54(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from strerror */
static C_word C_fcall stub9(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub9(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

/* from make-nonblocking in k1095 in k1092 in k1089 in k1086 in k1083 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_externexport void C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
static void f_1085(C_word c,C_word t0,C_word t1) C_noret;
static void f_1088(C_word c,C_word t0,C_word t1) C_noret;
static void f_1091(C_word c,C_word t0,C_word t1) C_noret;
static void f_1094(C_word c,C_word t0,C_word t1) C_noret;
static void f_1097(C_word c,C_word t0,C_word t1) C_noret;
static void f_2219(C_word c,C_word t0,C_word t1) C_noret;
static void f_4736(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2268(C_word c,C_word t0,C_word t1) C_noret;
static void f_2777(C_word c,C_word t0,C_word t1) C_noret;
static void f_4716(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4712(C_word c,C_word t0,C_word t1) C_noret;
static void f_4493(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_4493r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void C_fcall f_4641(C_word t0,C_word t1) C_noret;
static void f_4647(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_4636(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4631(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_4495(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4618(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4626(C_word c,C_word t0,C_word t1,...) C_noret;
static void C_fcall f_4499(C_word t0,C_word t1) C_noret;
static void f_4606(C_word c,C_word t0,C_word t1) C_noret;
static void f_4509(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4511(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4530(C_word c,C_word t0,C_word t1) C_noret;
static void f_4592(C_word c,C_word t0,C_word t1) C_noret;
static void f_4599(C_word c,C_word t0,C_word t1) C_noret;
static void f_4586(C_word c,C_word t0,C_word t1) C_noret;
static void f_4545(C_word c,C_word t0,C_word t1) C_noret;
static void f_4576(C_word c,C_word t0,C_word t1) C_noret;
static void f_4562(C_word c,C_word t0,C_word t1) C_noret;
static void f_4574(C_word c,C_word t0,C_word t1) C_noret;
static void f_4570(C_word c,C_word t0,C_word t1) C_noret;
static void f_4557(C_word c,C_word t0,C_word t1) C_noret;
static void f_4555(C_word c,C_word t0,C_word t1) C_noret;
static void f_4610(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4185(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4185r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_4448(C_word t0,C_word t1) C_noret;
static void C_fcall f_4443(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4187(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4211(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4392(C_word c,C_word t0,C_word t1) C_noret;
static void f_4396(C_word c,C_word t0,C_word t1) C_noret;
static void f_4399(C_word c,C_word t0,C_word t1) C_noret;
static void f_4439(C_word c,C_word t0,C_word t1) C_noret;
static void f_4402(C_word c,C_word t0,C_word t1) C_noret;
static void f_4430(C_word c,C_word t0,C_word t1) C_noret;
static void f_4405(C_word c,C_word t0,C_word t1) C_noret;
static void f_4414(C_word c,C_word t0,C_word t1) C_noret;
static void f_4215(C_word c,C_word t0,C_word t1) C_noret;
static void f_4218(C_word c,C_word t0,C_word t1) C_noret;
static void f_4221(C_word c,C_word t0,C_word t1) C_noret;
static void f_4234(C_word c,C_word t0,C_word t1) C_noret;
static void f_4379(C_word c,C_word t0,C_word t1) C_noret;
static void f_4383(C_word c,C_word t0,C_word t1) C_noret;
static void f_4363(C_word c,C_word t0,C_word t1) C_noret;
static void f_4347(C_word c,C_word t0,C_word t1) C_noret;
static void f_4351(C_word c,C_word t0,C_word t1) C_noret;
static void f_4278(C_word c,C_word t0,C_word t1) C_noret;
static void f_4334(C_word c,C_word t0,C_word t1) C_noret;
static void f_4338(C_word c,C_word t0,C_word t1) C_noret;
static void f_4284(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4293(C_word t0,C_word t1) C_noret;
static void f_4325(C_word c,C_word t0,C_word t1) C_noret;
static void f_4309(C_word c,C_word t0,C_word t1) C_noret;
static void f_4282(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4236(C_word t0,C_word t1) C_noret;
static void C_fcall f_4250(C_word t0,C_word t1) C_noret;
static void f_4266(C_word c,C_word t0,C_word t1) C_noret;
static void f_4269(C_word c,C_word t0,C_word t1) C_noret;
static void f_4246(C_word c,C_word t0,C_word t1) C_noret;
static void f_4205(C_word c,C_word t0,C_word t1) C_noret;
static void f_4193(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4165(C_word t0,C_word t1,C_word t2) C_noret;
static void f_4177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4171(C_word c,C_word t0,C_word t1) C_noret;
static void f_4119(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4119r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4126(C_word c,C_word t0,C_word t1) C_noret;
static void f_4141(C_word c,C_word t0,C_word t1) C_noret;
static void f_4098(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4098r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4095(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4092(C_word c,C_word t0,C_word t1) C_noret;
static void f_4089(C_word c,C_word t0,C_word t1) C_noret;
static void f_4019(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4019r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3855(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3855r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_3974(C_word t0,C_word t1) C_noret;
static void C_fcall f_3969(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_3857(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3861(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3869(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static C_word C_fcall f_3912(C_word t0,C_word t1,C_word t2);
static void C_fcall f_3882(C_word t0,C_word t1) C_noret;
static void f_3907(C_word c,C_word t0,C_word t1) C_noret;
static void f_3885(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_3847(C_word t0,C_word t1,C_word t2);
static C_word C_fcall f_3839(C_word t0,C_word t1,C_word t2);
static void f_3801(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3801r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3823(C_word c,C_word t0,C_word t1) C_noret;
static void f_3827(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3695(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3695r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_3701(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3722(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_3793(C_word c,C_word t0,C_word t1) C_noret;
static void f_3726(C_word c,C_word t0,C_word t1) C_noret;
static void f_3733(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3735(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3752(C_word c,C_word t0,C_word t1) C_noret;
static void f_3762(C_word c,C_word t0,C_word t1) C_noret;
static void f_3766(C_word c,C_word t0,C_word t1) C_noret;
static void f_3716(C_word c,C_word t0,C_word t1) C_noret;
static void f_3683(C_word c,C_word t0,C_word t1) C_noret;
static void f_3687(C_word c,C_word t0,C_word t1) C_noret;
static void f_3690(C_word c,C_word t0,C_word t1) C_noret;
static void f_3656(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3660(C_word c,C_word t0,C_word t1) C_noret;
static void f_3635(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3639(C_word c,C_word t0,C_word t1) C_noret;
static void f_3582(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_3582r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_3589(C_word c,C_word t0,C_word t1) C_noret;
static void f_3579(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3560(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3560r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3564(C_word c,C_word t0,C_word t1) C_noret;
static void f_3552(C_word c,C_word t0,C_word t1) C_noret;
static void f_3524(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3531(C_word c,C_word t0,C_word t1) C_noret;
static void f_3496(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3503(C_word c,C_word t0,C_word t1) C_noret;
static void f_3468(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3475(C_word c,C_word t0,C_word t1) C_noret;
static void f_3478(C_word c,C_word t0,C_word t1) C_noret;
static void f_3481(C_word c,C_word t0,C_word t1) C_noret;
static void f_3451(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3455(C_word c,C_word t0,C_word t1) C_noret;
static void f_3458(C_word c,C_word t0,C_word t1) C_noret;
static void f_3440(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3434(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3428(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3422(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3390(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3390r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3332(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f_3332r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f_3336(C_word c,C_word t0,C_word t1) C_noret;
static void f_3342(C_word c,C_word t0,C_word t1) C_noret;
static void f_3361(C_word c,C_word t0,C_word t1) C_noret;
static void f_3348(C_word c,C_word t0,C_word t1) C_noret;
static void f_3249(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3255(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3259(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3267(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3293(C_word c,C_word t0,C_word t1) C_noret;
static void f_3297(C_word c,C_word t0,C_word t1) C_noret;
static void f_3285(C_word c,C_word t0,C_word t1) C_noret;
static void f_3237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3242(C_word c,C_word t0,C_word t1) C_noret;
static void f_3226(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3231(C_word c,C_word t0,C_word t1) C_noret;
static void f_3235(C_word c,C_word t0,C_word t1) C_noret;
static void f_3203(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3224(C_word c,C_word t0,C_word t1) C_noret;
static void f_3207(C_word c,C_word t0,C_word t1) C_noret;
static void f_3166(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3166r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_3170(C_word t0,C_word t1) C_noret;
static void f_3188(C_word c,C_word t0,C_word t1) C_noret;
static void f_3184(C_word c,C_word t0,C_word t1) C_noret;
static void f_3141(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3119(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3119r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3123(C_word c,C_word t0,C_word t1) C_noret;
static void f_3104(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3104r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3108(C_word c,C_word t0,C_word t1) C_noret;
static void f_3089(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3089r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3093(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3071(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_3009(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_3028(C_word t0,C_word t1) C_noret;
static void f_2973(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2998(C_word c,C_word t0,C_word t1) C_noret;
static void f_2994(C_word c,C_word t0,C_word t1) C_noret;
static void f_2987(C_word c,C_word t0,C_word t1) C_noret;
static void f_2952(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2952r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_2956(C_word t0,C_word t1) C_noret;
static void f_2959(C_word c,C_word t0,C_word t1) C_noret;
static void f_2910(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2946(C_word c,C_word t0,C_word t1) C_noret;
static void f_2929(C_word c,C_word t0,C_word t1) C_noret;
static void f_2899(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2899r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2908(C_word c,C_word t0,C_word t1) C_noret;
static void f_2888(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2888r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2897(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2873(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2886(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2836(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2844(C_word c,C_word t0,C_word t1) C_noret;
static void f_2817(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2806(C_word c,C_word t0,C_word t1) C_noret;
static void f_2810(C_word c,C_word t0,C_word t1) C_noret;
static void f_2778(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2799(C_word c,C_word t0,C_word t1) C_noret;
static void f_2783(C_word c,C_word t0,C_word t1) C_noret;
static void f_2786(C_word c,C_word t0,C_word t1) C_noret;
static void f_2746(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2773(C_word c,C_word t0,C_word t1) C_noret;
static void f_2761(C_word c,C_word t0,C_word t1) C_noret;
static void f_2769(C_word c,C_word t0,C_word t1) C_noret;
static void f_2765(C_word c,C_word t0,C_word t1) C_noret;
static void f_2731(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2741(C_word c,C_word t0,C_word t1) C_noret;
static void f_2716(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2726(C_word c,C_word t0,C_word t1) C_noret;
static void f_2720(C_word c,C_word t0,C_word t1) C_noret;
static void f_2701(C_word c,C_word t0,C_word t1) C_noret;
static void f_2711(C_word c,C_word t0,C_word t1) C_noret;
static void f_2705(C_word c,C_word t0,C_word t1) C_noret;
static void f_2695(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2689(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2683(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_2662(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2681(C_word c,C_word t0,C_word t1) C_noret;
static void f_2677(C_word c,C_word t0,C_word t1) C_noret;
static void f_2669(C_word c,C_word t0,C_word t1) C_noret;
static void f_2647(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2657(C_word c,C_word t0,C_word t1) C_noret;
static void f_2632(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2642(C_word c,C_word t0,C_word t1) C_noret;
static void f_2629(C_word c,C_word t0,C_word t1) C_noret;
static void f_2626(C_word c,C_word t0,C_word t1) C_noret;
static void f_2623(C_word c,C_word t0,C_word t1) C_noret;
static void f_2620(C_word c,C_word t0,C_word t1) C_noret;
static void f_2599(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2618(C_word c,C_word t0,C_word t1) C_noret;
static void f_2614(C_word c,C_word t0,C_word t1) C_noret;
static void f_2578(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2597(C_word c,C_word t0,C_word t1) C_noret;
static void f_2593(C_word c,C_word t0,C_word t1) C_noret;
static void f_2536(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2532(C_word c,C_word t0,C_word t1) C_noret;
static void f_2546(C_word c,C_word t0,C_word t1) C_noret;
static void f_2473(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2477(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2482(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2498(C_word c,C_word t0,C_word t1) C_noret;
static void f_2410(C_word c,C_word t0,C_word t1) C_noret;
static void f_2468(C_word c,C_word t0,C_word t1) C_noret;
static void f_2414(C_word c,C_word t0,C_word t1) C_noret;
static void f_2417(C_word c,C_word t0,C_word t1) C_noret;
static void f_2449(C_word c,C_word t0,C_word t1) C_noret;
static void f_2420(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2425(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2439(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_2407(C_word t0);
static void f_2353(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2402(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2357(C_word t0,C_word t1) C_noret;
static void f_2367(C_word c,C_word t0,C_word t1) C_noret;
static void f_2371(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2377(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2381(C_word c,C_word t0,C_word t1) C_noret;
static void f_2391(C_word c,C_word t0,C_word t1) C_noret;
static void f_2375(C_word c,C_word t0,C_word t1) C_noret;
static void f_2308(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2345(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2312(C_word t0,C_word t1) C_noret;
static void f_2322(C_word c,C_word t0,C_word t1) C_noret;
static void f_2326(C_word c,C_word t0,C_word t1) C_noret;
static void f_2330(C_word c,C_word t0,C_word t1) C_noret;
static void f_2334(C_word c,C_word t0,C_word t1) C_noret;
static void f_2338(C_word c,C_word t0,C_word t1) C_noret;
static void f_2270(C_word c,C_word t0,C_word t1) C_noret;
static void f_2303(C_word c,C_word t0,C_word t1) C_noret;
static void f_2274(C_word c,C_word t0,C_word t1) C_noret;
static void f_2281(C_word c,C_word t0,C_word t1) C_noret;
static void f_2285(C_word c,C_word t0,C_word t1) C_noret;
static void f_2289(C_word c,C_word t0,C_word t1) C_noret;
static void f_2293(C_word c,C_word t0,C_word t1) C_noret;
static void f_2297(C_word c,C_word t0,C_word t1) C_noret;
static void f_2249(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2264(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2253(C_word c,C_word t0,C_word t1) C_noret;
static void f_2231(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2241(C_word c,C_word t0,C_word t1) C_noret;
static void f_2221(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2178(C_word c,C_word t0,C_word t1) C_noret;
static void f_2182(C_word c,C_word t0,C_word t1) C_noret;
static void f_2158(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2158r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2162(C_word c,C_word t0,C_word t1) C_noret;
static void f_2168(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2168r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2172(C_word c,C_word t0,C_word t1) C_noret;
static void f_2138(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2138r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2142(C_word c,C_word t0,C_word t1) C_noret;
static void f_2148(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2148r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2152(C_word c,C_word t0,C_word t1) C_noret;
static void f_2114(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2114r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2118(C_word c,C_word t0,C_word t1) C_noret;
static void f_2129(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2129r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2133(C_word c,C_word t0,C_word t1) C_noret;
static void f_2123(C_word c,C_word t0,C_word t1) C_noret;
static void f_2090(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2090r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2094(C_word c,C_word t0,C_word t1) C_noret;
static void f_2105(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2105r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2109(C_word c,C_word t0,C_word t1) C_noret;
static void f_2099(C_word c,C_word t0,C_word t1) C_noret;
static void f_2077(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2081(C_word c,C_word t0,C_word t1) C_noret;
static void f_2044(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2044r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2072(C_word c,C_word t0,C_word t1) C_noret;
static void f_2062(C_word c,C_word t0,C_word t1) C_noret;
static void f_2055(C_word c,C_word t0,C_word t1) C_noret;
static void f_2011(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2011r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2039(C_word c,C_word t0,C_word t1) C_noret;
static void f_2029(C_word c,C_word t0,C_word t1) C_noret;
static void f_2022(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1996(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2009(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1990(C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1978(C_word t0);
static void f_1938(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_1938r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_1942(C_word t0,C_word t1) C_noret;
static void f_1951(C_word c,C_word t0,C_word t1) C_noret;
static void f_1918(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1936(C_word c,C_word t0,C_word t1) C_noret;
static void f_1922(C_word c,C_word t0,C_word t1) C_noret;
static void f_1767(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_1767r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_1869(C_word t0,C_word t1) C_noret;
static void f_1877(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1864(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_1769(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_1773(C_word c,C_word t0,C_word t1) C_noret;
static void f_1776(C_word c,C_word t0,C_word t1) C_noret;
static void f_1779(C_word c,C_word t0,C_word t1) C_noret;
static void f_1863(C_word c,C_word t0,C_word t1) C_noret;
static void f_1783(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1797(C_word t0,C_word t1) C_noret;
static void f_1807(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1819(C_word t0,C_word t1) C_noret;
static void f_1829(C_word c,C_word t0,C_word t1) C_noret;
static void f_1746(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1765(C_word c,C_word t0,C_word t1) C_noret;
static void f_1761(C_word c,C_word t0,C_word t1) C_noret;
static void f_1725(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1744(C_word c,C_word t0,C_word t1) C_noret;
static void f_1740(C_word c,C_word t0,C_word t1) C_noret;
static void f_1704(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1723(C_word c,C_word t0,C_word t1) C_noret;
static void f_1719(C_word c,C_word t0,C_word t1) C_noret;
static void f_1652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1652r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1659(C_word c,C_word t0,C_word t1) C_noret;
static void f_1671(C_word c,C_word t0,C_word t1) C_noret;
static void f_1665(C_word c,C_word t0,C_word t1) C_noret;
static void f_1615(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1631(C_word c,C_word t0,C_word t1) C_noret;
static void f_1619(C_word c,C_word t0,C_word t1) C_noret;
static void f_1622(C_word c,C_word t0,C_word t1) C_noret;
static void f_1609(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1613(C_word c,C_word t0,C_word t1) C_noret;
static void f_1603(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1607(C_word c,C_word t0,C_word t1) C_noret;
static void f_1597(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1601(C_word c,C_word t0,C_word t1) C_noret;
static void f_1591(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1595(C_word c,C_word t0,C_word t1) C_noret;
static void f_1585(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1589(C_word c,C_word t0,C_word t1) C_noret;
static void f_1579(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1583(C_word c,C_word t0,C_word t1) C_noret;
static void f_1573(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1577(C_word c,C_word t0,C_word t1) C_noret;
static void f_1567(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1571(C_word c,C_word t0,C_word t1) C_noret;
static void f_1538(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_1538r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_1549(C_word t0,C_word t1) C_noret;
static void f_1542(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1501(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_1533(C_word c,C_word t0,C_word t1) C_noret;
static void f_1526(C_word c,C_word t0,C_word t1) C_noret;
static void f_1505(C_word c,C_word t0,C_word t1) C_noret;
static void f_1324(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1324r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1485(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1340(C_word c,C_word t0,C_word t1) C_noret;
static void f_1465(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1346(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1349(C_word t0,C_word t1) C_noret;
static void f_1431(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1429(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1388(C_word t0,C_word t1) C_noret;
static void f_1406(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1404(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1392(C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1322(C_word t0,C_word t1);
static C_word C_fcall f_1320(C_word t0,C_word t1);
static C_word C_fcall f_1318(C_word t0);
static void f_1289(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1293(C_word c,C_word t0,C_word t1) C_noret;
static void f_1296(C_word c,C_word t0,C_word t1) C_noret;
static void f_1299(C_word c,C_word t0,C_word t1) C_noret;
static void f_1306(C_word c,C_word t0,C_word t1) C_noret;
static void f_1256(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1256r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1260(C_word c,C_word t0,C_word t1) C_noret;
static void f_1266(C_word c,C_word t0,C_word t1) C_noret;
static void f_1220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1220r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1224(C_word c,C_word t0,C_word t1) C_noret;
static void f_1227(C_word c,C_word t0,C_word t1) C_noret;
static void f_1230(C_word c,C_word t0,C_word t1) C_noret;
static void f_1208(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1179r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1200(C_word c,C_word t0,C_word t1) C_noret;
static void f_1187(C_word c,C_word t0,C_word t1) C_noret;
static void f_1190(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1124(C_word t0) C_noret;
static void f_1130(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1139(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1107(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
static void f_1111(C_word c,C_word t0,C_word t1) C_noret;
static void f_1122(C_word c,C_word t0,C_word t1) C_noret;
static void f_1118(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1099(C_word t0);

static void C_fcall trf_4641(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4641(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4641(t0,t1);}

static void C_fcall trf_4636(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4636(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4636(t0,t1,t2);}

static void C_fcall trf_4631(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4631(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4631(t0,t1,t2,t3);}

static void C_fcall trf_4495(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4495(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4495(t0,t1,t2,t3,t4);}

static void C_fcall trf_4499(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4499(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4499(t0,t1);}

static void C_fcall trf_4511(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4511(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4511(t0,t1,t2,t3);}

static void C_fcall trf_4448(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4448(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4448(t0,t1);}

static void C_fcall trf_4443(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4443(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4443(t0,t1,t2);}

static void C_fcall trf_4187(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4187(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4187(t0,t1,t2,t3);}

static void C_fcall trf_4293(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4293(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4293(t0,t1);}

static void C_fcall trf_4236(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4236(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4236(t0,t1);}

static void C_fcall trf_4250(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4250(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4250(t0,t1);}

static void C_fcall trf_4165(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4165(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4165(t0,t1,t2);}

static void C_fcall trf_3974(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3974(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3974(t0,t1);}

static void C_fcall trf_3969(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3969(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3969(t0,t1,t2);}

static void C_fcall trf_3857(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3857(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3857(t0,t1,t2,t3);}

static void C_fcall trf_3869(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3869(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3869(t0,t1,t2,t3);}

static void C_fcall trf_3882(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3882(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3882(t0,t1);}

static void C_fcall trf_3701(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3701(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3701(t0,t1,t2);}

static void C_fcall trf_3735(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3735(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3735(t0,t1,t2);}

static void C_fcall trf_3255(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3255(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3255(t0,t1,t2);}

static void C_fcall trf_3267(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3267(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3267(t0,t1,t2);}

static void C_fcall trf_3170(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3170(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3170(t0,t1);}

static void C_fcall trf_3071(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3071(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3071(t0,t1,t2,t3);}

static void C_fcall trf_3009(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3009(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3009(t0,t1,t2);}

static void C_fcall trf_3028(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3028(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3028(t0,t1);}

static void C_fcall trf_2956(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2956(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2956(t0,t1);}

static void C_fcall trf_2873(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2873(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2873(t0,t1,t2,t3,t4);}

static void C_fcall trf_2836(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2836(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2836(t0,t1,t2);}

static void C_fcall trf_2662(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2662(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2662(t0,t1,t2);}

static void C_fcall trf_2482(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2482(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2482(t0,t1,t2,t3);}

static void C_fcall trf_2425(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2425(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2425(t0,t1,t2);}

static void C_fcall trf_2357(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2357(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2357(t0,t1);}

static void C_fcall trf_2377(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2377(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2377(t0,t1,t2);}

static void C_fcall trf_2312(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2312(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2312(t0,t1);}

static void C_fcall trf_1996(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1996(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_1996(t0,t1,t2,t3,t4);}

static void C_fcall trf_1990(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1990(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1990(t0,t1);}

static void C_fcall trf_1942(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1942(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1942(t0,t1);}

static void C_fcall trf_1869(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1869(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1869(t0,t1);}

static void C_fcall trf_1864(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1864(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1864(t0,t1,t2);}

static void C_fcall trf_1769(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1769(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1769(t0,t1,t2,t3);}

static void C_fcall trf_1797(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1797(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1797(t0,t1);}

static void C_fcall trf_1819(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1819(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1819(t0,t1);}

static void C_fcall trf_1549(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1549(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1549(t0,t1);}

static void C_fcall trf_1501(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1501(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1501(t0,t1,t2,t3);}

static void C_fcall trf_1349(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1349(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1349(t0,t1);}

static void C_fcall trf_1388(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1388(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1388(t0,t1);}

static void C_fcall trf_1392(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1392(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1392(t0,t1);}

static void C_fcall trf_1124(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1124(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f_1124(t0);}

static void C_fcall trf_1107(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1107(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_1107(t0,t1,t2,t3,t4,t5);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(2331)){
C_save(t1);
C_rereclaim2(2331*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,362);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_h_intern(&lf[3],13,"string-append");
lf[5]=C_h_intern(&lf[5],15,"\003syssignal-hook");
lf[6]=C_static_string(C_heaptop,3," - ");
lf[7]=C_h_intern(&lf[7],17,"\003syspeek-c-string");
lf[8]=C_h_intern(&lf[8],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],18,"\003syscurrent-thread");
lf[11]=C_h_intern(&lf[11],12,"\003sysschedule");
lf[12]=C_h_intern(&lf[12],8,"pipe/buf");
lf[13]=C_h_intern(&lf[13],11,"open/rdonly");
lf[14]=C_h_intern(&lf[14],11,"open/wronly");
lf[15]=C_h_intern(&lf[15],9,"open/rdwr");
lf[16]=C_h_intern(&lf[16],9,"open/read");
lf[17]=C_h_intern(&lf[17],10,"open/write");
lf[18]=C_h_intern(&lf[18],10,"open/creat");
lf[19]=C_h_intern(&lf[19],11,"open/append");
lf[20]=C_h_intern(&lf[20],9,"open/excl");
lf[21]=C_h_intern(&lf[21],11,"open/noctty");
lf[22]=C_h_intern(&lf[22],13,"open/nonblock");
lf[23]=C_h_intern(&lf[23],10,"open/trunc");
lf[24]=C_h_intern(&lf[24],9,"open/sync");
lf[25]=C_h_intern(&lf[25],10,"open/fsync");
lf[26]=C_h_intern(&lf[26],11,"open/binary");
lf[27]=C_h_intern(&lf[27],9,"open/text");
lf[28]=C_h_intern(&lf[28],10,"perm/irusr");
lf[29]=C_h_intern(&lf[29],10,"perm/iwusr");
lf[30]=C_h_intern(&lf[30],10,"perm/ixusr");
lf[31]=C_h_intern(&lf[31],10,"perm/irgrp");
lf[32]=C_h_intern(&lf[32],10,"perm/iwgrp");
lf[33]=C_h_intern(&lf[33],10,"perm/ixgrp");
lf[34]=C_h_intern(&lf[34],10,"perm/iroth");
lf[35]=C_h_intern(&lf[35],10,"perm/iwoth");
lf[36]=C_h_intern(&lf[36],10,"perm/ixoth");
lf[37]=C_h_intern(&lf[37],10,"perm/irwxu");
lf[38]=C_h_intern(&lf[38],10,"perm/irwxg");
lf[39]=C_h_intern(&lf[39],10,"perm/irwxo");
lf[40]=C_h_intern(&lf[40],10,"perm/isvtx");
lf[41]=C_h_intern(&lf[41],10,"perm/isuid");
lf[42]=C_h_intern(&lf[42],10,"perm/isgid");
lf[43]=C_h_intern(&lf[43],9,"file-open");
lf[44]=C_h_intern(&lf[44],11,"\000file-error");
lf[45]=C_static_string(C_heaptop,17,"can not open file");
lf[46]=C_h_intern(&lf[46],17,"\003sysmake-c-string");
lf[47]=C_h_intern(&lf[47],20,"\003sysexpand-home-path");
lf[48]=C_h_intern(&lf[48],10,"file-close");
lf[49]=C_static_string(C_heaptop,18,"can not close file");
lf[50]=C_h_intern(&lf[50],11,"make-string");
lf[51]=C_h_intern(&lf[51],9,"file-read");
lf[52]=C_static_string(C_heaptop,22,"can not read from file");
lf[53]=C_h_intern(&lf[53],11,"\000type-error");
lf[54]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[55]=C_h_intern(&lf[55],10,"file-write");
lf[56]=C_static_string(C_heaptop,21,"can not write to file");
lf[57]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[58]=C_h_intern(&lf[58],13,"string-length");
lf[59]=C_h_intern(&lf[59],12,"file-mkstemp");
lf[60]=C_h_intern(&lf[60],13,"\003syssubstring");
lf[61]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[62]=C_h_intern(&lf[62],11,"file-select");
lf[63]=C_static_string(C_heaptop,6,"failed");
lf[64]=C_h_intern(&lf[64],12,"\003sysfor-each");
lf[65]=C_h_intern(&lf[65],8,"seek/set");
lf[66]=C_h_intern(&lf[66],8,"seek/end");
lf[67]=C_h_intern(&lf[67],8,"seek/cur");
lf[69]=C_static_string(C_heaptop,19,"can not access file");
lf[70]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[71]=C_h_intern(&lf[71],9,"file-stat");
lf[72]=C_h_intern(&lf[72],9,"file-size");
lf[73]=C_h_intern(&lf[73],22,"file-modification-time");
lf[74]=C_h_intern(&lf[74],16,"file-access-time");
lf[75]=C_h_intern(&lf[75],16,"file-change-time");
lf[76]=C_h_intern(&lf[76],10,"file-owner");
lf[77]=C_h_intern(&lf[77],16,"file-permissions");
lf[78]=C_h_intern(&lf[78],13,"regular-file\077");
lf[79]=C_h_intern(&lf[79],14,"symbolic-link\077");
lf[80]=C_h_intern(&lf[80],13,"file-position");
lf[81]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[82]=C_h_intern(&lf[82],6,"stream");
lf[83]=C_static_string(C_heaptop,12,"invalid file");
lf[84]=C_h_intern(&lf[84],5,"port\077");
lf[85]=C_h_intern(&lf[85],18,"set-file-position!");
lf[86]=C_static_string(C_heaptop,25,"can not set file position");
lf[87]=C_static_string(C_heaptop,12,"invalid file");
lf[88]=C_h_intern(&lf[88],13,"\000bounds-error");
lf[89]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[90]=C_h_intern(&lf[90],16,"create-directory");
lf[91]=C_static_string(C_heaptop,24,"can not create directory");
lf[92]=C_h_intern(&lf[92],16,"change-directory");
lf[93]=C_static_string(C_heaptop,32,"can not change current directory");
lf[94]=C_h_intern(&lf[94],16,"delete-directory");
lf[95]=C_static_string(C_heaptop,24,"can not delete directory");
lf[96]=C_h_intern(&lf[96],6,"string");
lf[97]=C_h_intern(&lf[97],9,"directory");
lf[98]=C_static_string(C_heaptop,22,"can not open directory");
lf[99]=C_h_intern(&lf[99],16,"\003sysmake-pointer");
lf[100]=C_h_intern(&lf[100],17,"current-directory");
lf[101]=C_h_intern(&lf[101],10,"directory\077");
lf[102]=C_h_intern(&lf[102],13,"\003sysfile-info");
lf[103]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[104]=C_h_intern(&lf[104],5,"\000text");
lf[105]=C_h_intern(&lf[105],9,"\003syserror");
lf[106]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[107]=C_static_string(C_heaptop,17,"can not open pipe");
lf[108]=C_h_intern(&lf[108],13,"\003sysmake-port");
lf[109]=C_h_intern(&lf[109],21,"\003sysstream-port-class");
lf[110]=C_static_string(C_heaptop,6,"(pipe)");
lf[111]=C_h_intern(&lf[111],15,"open-input-pipe");
lf[112]=C_h_intern(&lf[112],7,"\000binary");
lf[113]=C_h_intern(&lf[113],16,"open-output-pipe");
lf[114]=C_h_intern(&lf[114],16,"close-input-pipe");
lf[115]=C_h_intern(&lf[115],23,"close-input/output-pipe");
lf[116]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[117]=C_h_intern(&lf[117],17,"close-output-pipe");
lf[118]=C_h_intern(&lf[118],20,"call-with-input-pipe");
lf[119]=C_h_intern(&lf[119],21,"call-with-output-pipe");
lf[120]=C_h_intern(&lf[120],20,"with-input-from-pipe");
lf[121]=C_h_intern(&lf[121],18,"\003sysstandard-input");
lf[122]=C_h_intern(&lf[122],19,"with-output-to-pipe");
lf[123]=C_h_intern(&lf[123],19,"\003sysstandard-output");
lf[124]=C_h_intern(&lf[124],11,"create-pipe");
lf[125]=C_static_string(C_heaptop,19,"can not create pipe");
lf[126]=C_h_intern(&lf[126],11,"signal/term");
lf[127]=C_h_intern(&lf[127],11,"signal/kill");
lf[128]=C_h_intern(&lf[128],10,"signal/int");
lf[129]=C_h_intern(&lf[129],10,"signal/hup");
lf[130]=C_h_intern(&lf[130],10,"signal/fpe");
lf[131]=C_h_intern(&lf[131],10,"signal/ill");
lf[132]=C_h_intern(&lf[132],11,"signal/segv");
lf[133]=C_h_intern(&lf[133],11,"signal/abrt");
lf[134]=C_h_intern(&lf[134],11,"signal/trap");
lf[135]=C_h_intern(&lf[135],11,"signal/quit");
lf[136]=C_h_intern(&lf[136],11,"signal/alrm");
lf[137]=C_h_intern(&lf[137],13,"signal/vtalrm");
lf[138]=C_h_intern(&lf[138],11,"signal/prof");
lf[139]=C_h_intern(&lf[139],9,"signal/io");
lf[140]=C_h_intern(&lf[140],10,"signal/urg");
lf[141]=C_h_intern(&lf[141],11,"signal/chld");
lf[142]=C_h_intern(&lf[142],11,"signal/cont");
lf[143]=C_h_intern(&lf[143],11,"signal/stop");
lf[144]=C_h_intern(&lf[144],11,"signal/tstp");
lf[145]=C_h_intern(&lf[145],11,"signal/pipe");
lf[146]=C_h_intern(&lf[146],11,"signal/xcpu");
lf[147]=C_h_intern(&lf[147],11,"signal/xfsz");
lf[148]=C_h_intern(&lf[148],11,"signal/usr1");
lf[149]=C_h_intern(&lf[149],11,"signal/usr2");
lf[150]=C_h_intern(&lf[150],12,"signal/winch");
lf[151]=C_h_intern(&lf[151],18,"\003sysinterrupt-hook");
lf[152]=C_h_intern(&lf[152],19,"set-signal-handler!");
lf[153]=C_h_intern(&lf[153],18,"\003syscontext-switch");
lf[154]=C_h_intern(&lf[154],16,"set-signal-mask!");
lf[155]=C_h_intern(&lf[155],14,"\000process-error");
lf[156]=C_static_string(C_heaptop,23,"can not set signal mask");
lf[157]=C_h_intern(&lf[157],18,"system-information");
lf[158]=C_h_intern(&lf[158],25,"\003syspeek-nonnull-c-string");
lf[159]=C_static_string(C_heaptop,35,"can not retrieve system information");
lf[160]=C_h_intern(&lf[160],16,"user-information");
lf[161]=C_h_intern(&lf[161],17,"group-information");
lf[163]=C_h_intern(&lf[163],10,"get-groups");
lf[164]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[165]=C_static_string(C_heaptop,13,"out of memory");
lf[166]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[167]=C_h_intern(&lf[167],11,"set-groups!");
lf[168]=C_static_string(C_heaptop,35,"can not set supplementary group ids");
lf[169]=C_static_string(C_heaptop,13,"out of memory");
lf[170]=C_h_intern(&lf[170],17,"initialize-groups");
lf[171]=C_static_string(C_heaptop,42,"can not initialize supplementary group ids");
lf[172]=C_h_intern(&lf[172],10,"errno/perm");
lf[173]=C_h_intern(&lf[173],11,"errno/noent");
lf[174]=C_h_intern(&lf[174],10,"errno/srch");
lf[175]=C_h_intern(&lf[175],10,"errno/intr");
lf[176]=C_h_intern(&lf[176],8,"errno/io");
lf[177]=C_h_intern(&lf[177],12,"errno/noexec");
lf[178]=C_h_intern(&lf[178],10,"errno/badf");
lf[179]=C_h_intern(&lf[179],11,"errno/child");
lf[180]=C_h_intern(&lf[180],11,"errno/nomem");
lf[181]=C_h_intern(&lf[181],11,"errno/acces");
lf[182]=C_h_intern(&lf[182],11,"errno/fault");
lf[183]=C_h_intern(&lf[183],10,"errno/busy");
lf[184]=C_h_intern(&lf[184],12,"errno/notdir");
lf[185]=C_h_intern(&lf[185],11,"errno/isdir");
lf[186]=C_h_intern(&lf[186],11,"errno/inval");
lf[187]=C_h_intern(&lf[187],11,"errno/mfile");
lf[188]=C_h_intern(&lf[188],11,"errno/nospc");
lf[189]=C_h_intern(&lf[189],11,"errno/spipe");
lf[190]=C_h_intern(&lf[190],10,"errno/pipe");
lf[191]=C_h_intern(&lf[191],11,"errno/again");
lf[192]=C_h_intern(&lf[192],10,"errno/rofs");
lf[193]=C_h_intern(&lf[193],11,"errno/exist");
lf[194]=C_h_intern(&lf[194],16,"errno/wouldblock");
lf[195]=C_h_intern(&lf[195],16,"change-file-mode");
lf[196]=C_static_string(C_heaptop,24,"can not change file mode");
lf[197]=C_h_intern(&lf[197],17,"change-file-owner");
lf[198]=C_static_string(C_heaptop,25,"can not change file owner");
lf[199]=C_h_intern(&lf[199],15,"current-user-id");
lf[200]=C_h_intern(&lf[200],16,"current-group-id");
lf[201]=C_h_intern(&lf[201],25,"current-effective-user-id");
lf[202]=C_h_intern(&lf[202],26,"current-effective-group-id");
lf[203]=C_h_intern(&lf[203],12,"set-user-id!");
lf[204]=C_static_string(C_heaptop,19,"can not set user ID");
lf[205]=C_h_intern(&lf[205],13,"set-group-id!");
lf[206]=C_static_string(C_heaptop,20,"can not set group ID");
lf[207]=C_h_intern(&lf[207],17,"file-read-access\077");
lf[208]=C_h_intern(&lf[208],18,"file-write-access\077");
lf[209]=C_h_intern(&lf[209],20,"file-execute-access\077");
lf[210]=C_h_intern(&lf[210],14,"create-session");
lf[211]=C_static_string(C_heaptop,22,"can not create session");
lf[212]=C_h_intern(&lf[212],16,"process-group-id");
lf[213]=C_static_string(C_heaptop,33,"can not retrieve process group ID");
lf[214]=C_h_intern(&lf[214],21,"set-process-group-id!");
lf[215]=C_static_string(C_heaptop,28,"can not set process group ID");
lf[216]=C_h_intern(&lf[216],20,"create-symbolic-link");
lf[217]=C_h_intern(&lf[217],18,"create-symbol-link");
lf[218]=C_static_string(C_heaptop,28,"can not create symbolic link");
lf[219]=C_h_intern(&lf[219],9,"substring");
lf[220]=C_h_intern(&lf[220],18,"read-symbolic-link");
lf[221]=C_static_string(C_heaptop,26,"can not read symbolic link");
lf[222]=C_h_intern(&lf[222],9,"file-link");
lf[223]=C_h_intern(&lf[223],9,"hard-link");
lf[224]=C_static_string(C_heaptop,26,"could not create hard link");
lf[225]=C_h_intern(&lf[225],12,"fileno/stdin");
lf[226]=C_h_intern(&lf[226],13,"fileno/stdout");
lf[227]=C_h_intern(&lf[227],13,"fileno/stderr");
lf[228]=C_h_intern(&lf[228],7,"\000append");
lf[229]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[230]=C_static_string(C_heaptop,1,"a");
lf[231]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[232]=C_static_string(C_heaptop,1,"r");
lf[233]=C_static_string(C_heaptop,1,"w");
lf[234]=C_static_string(C_heaptop,17,"can not open file");
lf[235]=C_static_string(C_heaptop,8,"(fdport)");
lf[236]=C_h_intern(&lf[236],16,"open-input-file*");
lf[237]=C_h_intern(&lf[237],17,"open-output-file*");
lf[238]=C_h_intern(&lf[238],12,"port->fileno");
lf[239]=C_h_intern(&lf[239],6,"socket");
lf[240]=C_h_intern(&lf[240],20,"\003systcp-port->fileno");
lf[241]=C_static_string(C_heaptop,25,"port has no attached file");
lf[242]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[243]=C_h_intern(&lf[243],25,"\003syspeek-unsigned-integer");
lf[244]=C_h_intern(&lf[244],16,"duplicate-fileno");
lf[245]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[246]=C_h_intern(&lf[246],13,"file-truncate");
lf[247]=C_static_string(C_heaptop,21,"can not truncate file");
lf[248]=C_static_string(C_heaptop,12,"invalid file");
lf[249]=C_h_intern(&lf[249],4,"lock");
lf[250]=C_h_intern(&lf[250],9,"file-lock");
lf[251]=C_static_string(C_heaptop,17,"can not lock file");
lf[252]=C_h_intern(&lf[252],18,"file-lock/blocking");
lf[253]=C_static_string(C_heaptop,17,"can not lock file");
lf[254]=C_h_intern(&lf[254],14,"file-test-lock");
lf[255]=C_static_string(C_heaptop,19,"can not unlock file");
lf[256]=C_h_intern(&lf[256],11,"file-unlock");
lf[257]=C_static_string(C_heaptop,19,"can not unlock file");
lf[258]=C_h_intern(&lf[258],11,"create-fifo");
lf[259]=C_static_string(C_heaptop,19,"can not create FIFO");
lf[260]=C_h_intern(&lf[260],5,"fifo\077");
lf[261]=C_static_string(C_heaptop,19,"file does not exist");
lf[262]=C_h_intern(&lf[262],6,"setenv");
lf[263]=C_h_intern(&lf[263],8,"unsetenv");
lf[264]=C_h_intern(&lf[264],19,"current-environment");
lf[265]=C_h_intern(&lf[265],9,"prot/read");
lf[266]=C_h_intern(&lf[266],10,"prot/write");
lf[267]=C_h_intern(&lf[267],9,"prot/exec");
lf[268]=C_h_intern(&lf[268],9,"prot/none");
lf[269]=C_h_intern(&lf[269],9,"map/fixed");
lf[270]=C_h_intern(&lf[270],10,"map/shared");
lf[271]=C_h_intern(&lf[271],11,"map/private");
lf[272]=C_h_intern(&lf[272],13,"map/anonymous");
lf[273]=C_h_intern(&lf[273],8,"map/file");
lf[274]=C_h_intern(&lf[274],18,"map-file-to-memory");
lf[275]=C_h_intern(&lf[275],4,"mmap");
lf[276]=C_static_string(C_heaptop,26,"can not map file to memory");
lf[277]=C_h_intern(&lf[277],20,"\003syspointer->address");
lf[278]=C_static_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[279]=C_h_intern(&lf[279],16,"\003sysnull-pointer");
lf[280]=C_h_intern(&lf[280],22,"unmap-file-from-memory");
lf[281]=C_static_string(C_heaptop,30,"can not unmap file from memory");
lf[282]=C_h_intern(&lf[282],26,"memory-mapped-file-pointer");
lf[283]=C_h_intern(&lf[283],19,"memory-mapped-file\077");
lf[284]=C_h_intern(&lf[284],19,"seconds->local-time");
lf[285]=C_h_intern(&lf[285],18,"\003sysdecode-seconds");
lf[286]=C_h_intern(&lf[286],17,"seconds->utc-time");
lf[287]=C_h_intern(&lf[287],15,"seconds->string");
lf[288]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[289]=C_h_intern(&lf[289],12,"time->string");
lf[290]=C_static_string(C_heaptop,37,"can not convert time vector to string");
lf[291]=C_static_string(C_heaptop,21,"time vector too short");
lf[292]=C_h_intern(&lf[292],19,"local-time->seconds");
lf[293]=C_h_intern(&lf[293],15,"\003syscons-flonum");
lf[294]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[295]=C_static_string(C_heaptop,21,"time vector too short");
lf[296]=C_h_intern(&lf[296],17,"utc-time->seconds");
lf[297]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[298]=C_static_string(C_heaptop,21,"time vector too short");
lf[299]=C_h_intern(&lf[299],27,"local-timezone-abbreviation");
lf[300]=C_h_intern(&lf[300],5,"_exit");
lf[301]=C_h_intern(&lf[301],23,"\003syscleanup-before-exit");
lf[302]=C_h_intern(&lf[302],10,"set-alarm!");
lf[303]=C_h_intern(&lf[303],19,"set-buffering-mode!");
lf[304]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[305]=C_h_intern(&lf[305],5,"\000full");
lf[306]=C_h_intern(&lf[306],5,"\000line");
lf[307]=C_h_intern(&lf[307],5,"\000none");
lf[308]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[309]=C_h_intern(&lf[309],14,"terminal-port\077");
lf[310]=C_h_intern(&lf[310],13,"terminal-name");
lf[311]=C_static_string(C_heaptop,35,"port is not connected to a terminal");
lf[312]=C_h_intern(&lf[312],13,"get-host-name");
lf[313]=C_h_intern(&lf[313],6,"\000error");
lf[314]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[315]=C_h_intern(&lf[315],12,"glob->regexp");
lf[316]=C_h_intern(&lf[316],13,"make-pathname");
lf[317]=C_h_intern(&lf[317],18,"decompose-pathname");
lf[318]=C_h_intern(&lf[318],4,"glob");
lf[319]=C_h_intern(&lf[319],12,"string-match");
lf[320]=C_static_string(C_heaptop,1,".");
lf[321]=C_static_string(C_heaptop,1,"*");
lf[322]=C_h_intern(&lf[322],12,"process-fork");
lf[323]=C_static_string(C_heaptop,28,"can not create child process");
lf[324]=C_h_intern(&lf[324],24,"pathname-strip-directory");
lf[325]=C_h_intern(&lf[325],15,"process-execute");
lf[326]=C_static_string(C_heaptop,23,"can not execute process");
lf[327]=C_h_intern(&lf[327],12,"process-wait");
lf[328]=C_static_string(C_heaptop,32,"waiting for child process failed");
lf[329]=C_h_intern(&lf[329],18,"current-process-id");
lf[330]=C_h_intern(&lf[330],17,"parent-process-id");
lf[331]=C_h_intern(&lf[331],5,"sleep");
lf[332]=C_h_intern(&lf[332],14,"process-signal");
lf[333]=C_static_string(C_heaptop,32,"could not send signal to process");
lf[334]=C_h_intern(&lf[334],6,"getenv");
lf[335]=C_h_intern(&lf[335],11,"process-run");
lf[336]=C_static_string(C_heaptop,7,"/bin/sh");
lf[337]=C_static_string(C_heaptop,2,"-c");
lf[338]=C_static_string(C_heaptop,5,"SHELL");
lf[339]=C_h_intern(&lf[339],15,"make-input-port");
lf[340]=C_h_intern(&lf[340],16,"make-output-port");
lf[341]=C_h_intern(&lf[341],7,"process");
lf[342]=C_static_string(C_heaptop,25,"process exited abnormally");
lf[343]=C_h_intern(&lf[343],25,"\003systhread-block-for-i/o!");
lf[344]=C_static_string(C_heaptop,22,"can not read from pipe");
lf[345]=C_static_string(C_heaptop,21,"can not write to pipe");
lf[346]=C_static_string(C_heaptop,7,"/bin/sh");
lf[347]=C_static_string(C_heaptop,2,"-c");
lf[348]=C_static_string(C_heaptop,5,"SHELL");
lf[349]=C_h_intern(&lf[349],10,"find-files");
lf[350]=C_static_string(C_heaptop,1,".");
lf[351]=C_static_string(C_heaptop,2,"..");
lf[352]=C_static_string(C_heaptop,1,"*");
lf[353]=C_h_intern(&lf[353],16,"\003sysdynamic-wind");
lf[354]=C_h_intern(&lf[354],13,"pathname-file");
lf[355]=C_static_string(C_heaptop,1,"*");
lf[356]=C_h_intern(&lf[356],19,"set-root-directory!");
lf[357]=C_static_string(C_heaptop,31,"unable to change root directory");
lf[358]=C_h_intern(&lf[358],23,"\003sysuser-interrupt-hook");
lf[359]=C_h_intern(&lf[359],11,"make-vector");
lf[360]=C_h_intern(&lf[360],17,"register-feature!");
lf[361]=C_h_intern(&lf[361],5,"posix");
C_register_lf2(lf,362,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1085,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1083 */
static void f_1085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1085,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1088,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1086 in k1083 */
static void f_1088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1088,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1091,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1089 in k1086 in k1083 */
static void f_1091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1091,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1094,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1092 in k1089 in k1086 in k1083 */
static void f_1094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1094,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1097,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 365  register-feature! */
t3=*((C_word*)lf[360]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[361]);}

/* k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word ab[117],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1097,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1099,tmp=(C_word)a,a+=2,tmp));
t3=*((C_word*)lf[3]+1);
t4=C_mutate(&lf[4],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1107,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=C_mutate(&lf[9],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1124,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[12]+1,C_fix((C_word)PIPE_BUF));
t7=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_RDONLY));
t8=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_RDONLY));
t11=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_WRONLY));
t12=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_APPEND));
t14=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_EXCL));
t15=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_NOCTTY));
t16=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_NONBLOCK));
t17=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_TRUNC));
t18=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_FSYNC));
t19=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_FSYNC));
t20=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_BINARY));
t21=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_TEXT));
t22=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IRUSR));
t23=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IWUSR));
t24=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IXUSR));
t25=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IRGRP));
t26=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IWGRP));
t27=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IXGRP));
t28=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IROTH));
t29=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IWOTH));
t30=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IXOTH));
t31=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IRWXU));
t32=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IRWXG));
t33=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IRWXO));
t34=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_ISVTX));
t35=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_ISUID));
t36=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_ISGID));
t37=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t38=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t37);
t39=C_mutate((C_word*)lf[43]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1179,a[2]=t38,tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1208,tmp=(C_word)a,a+=2,tmp));
t41=*((C_word*)lf[50]+1);
t42=C_mutate((C_word*)lf[51]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1220,a[2]=t41,tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1256,tmp=(C_word)a,a+=2,tmp));
t44=*((C_word*)lf[58]+1);
t45=C_mutate((C_word*)lf[59]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1289,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t46=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1318,tmp=(C_word)a,a+=2,tmp);
t47=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1320,tmp=(C_word)a,a+=2,tmp);
t48=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1322,tmp=(C_word)a,a+=2,tmp);
t49=C_mutate((C_word*)lf[62]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1324,a[2]=t47,a[3]=t48,a[4]=t46,tmp=(C_word)a,a+=5,tmp));
t50=C_mutate((C_word*)lf[65]+1,C_fix((C_word)SEEK_SET));
t51=C_mutate((C_word*)lf[66]+1,C_fix((C_word)SEEK_END));
t52=C_mutate((C_word*)lf[67]+1,C_fix((C_word)SEEK_CUR));
t53=C_mutate(&lf[68],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1501,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1538,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[72]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1567,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[73]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1573,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[74]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1579,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[75]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1585,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1591,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1597,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1603,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1609,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1615,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1652,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1704,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1725,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[94]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1746,tmp=(C_word)a,a+=2,tmp));
t68=*((C_word*)lf[3]+1);
t69=*((C_word*)lf[50]+1);
t70=*((C_word*)lf[96]+1);
t71=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1767,a[2]=t69,tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[101]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1918,tmp=(C_word)a,a+=2,tmp));
t73=*((C_word*)lf[50]+1);
t74=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1938,a[2]=t73,tmp=(C_word)a,a+=3,tmp));
t75=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1978,tmp=(C_word)a,a+=2,tmp);
t76=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1990,tmp=(C_word)a,a+=2,tmp);
t77=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1996,tmp=(C_word)a,a+=2,tmp);
t78=C_mutate((C_word*)lf[111]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2011,a[2]=t76,a[3]=t77,a[4]=t75,tmp=(C_word)a,a+=5,tmp));
t79=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2044,a[2]=t76,a[3]=t77,a[4]=t75,tmp=(C_word)a,a+=5,tmp));
t80=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2077,tmp=(C_word)a,a+=2,tmp));
t81=C_mutate((C_word*)lf[117]+1,*((C_word*)lf[114]+1));
t82=*((C_word*)lf[111]+1);
t83=*((C_word*)lf[113]+1);
t84=*((C_word*)lf[114]+1);
t85=*((C_word*)lf[117]+1);
t86=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2090,a[2]=t82,a[3]=t84,tmp=(C_word)a,a+=4,tmp));
t87=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2114,a[2]=t83,a[3]=t85,tmp=(C_word)a,a+=4,tmp));
t88=C_mutate((C_word*)lf[120]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2138,a[2]=t82,a[3]=t84,tmp=(C_word)a,a+=4,tmp));
t89=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2158,a[2]=t83,a[3]=t85,tmp=(C_word)a,a+=4,tmp));
t90=C_mutate((C_word*)lf[124]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2178,tmp=(C_word)a,a+=2,tmp));
t91=C_mutate((C_word*)lf[126]+1,C_fix((C_word)SIGTERM));
t92=C_mutate((C_word*)lf[127]+1,C_fix((C_word)SIGKILL));
t93=C_mutate((C_word*)lf[128]+1,C_fix((C_word)SIGINT));
t94=C_mutate((C_word*)lf[129]+1,C_fix((C_word)SIGHUP));
t95=C_mutate((C_word*)lf[130]+1,C_fix((C_word)SIGFPE));
t96=C_mutate((C_word*)lf[131]+1,C_fix((C_word)SIGILL));
t97=C_mutate((C_word*)lf[132]+1,C_fix((C_word)SIGSEGV));
t98=C_mutate((C_word*)lf[133]+1,C_fix((C_word)SIGABRT));
t99=C_mutate((C_word*)lf[134]+1,C_fix((C_word)SIGTRAP));
t100=C_mutate((C_word*)lf[135]+1,C_fix((C_word)SIGQUIT));
t101=C_mutate((C_word*)lf[136]+1,C_fix((C_word)SIGALRM));
t102=C_mutate((C_word*)lf[137]+1,C_fix((C_word)SIGVTALRM));
t103=C_mutate((C_word*)lf[138]+1,C_fix((C_word)SIGPROF));
t104=C_mutate((C_word*)lf[139]+1,C_fix((C_word)SIGIO));
t105=C_mutate((C_word*)lf[140]+1,C_fix((C_word)SIGURG));
t106=C_mutate((C_word*)lf[141]+1,C_fix((C_word)SIGCHLD));
t107=C_mutate((C_word*)lf[142]+1,C_fix((C_word)SIGCONT));
t108=C_mutate((C_word*)lf[143]+1,C_fix((C_word)SIGSTOP));
t109=C_mutate((C_word*)lf[144]+1,C_fix((C_word)SIGTSTP));
t110=C_mutate((C_word*)lf[145]+1,C_fix((C_word)SIGPIPE));
t111=C_mutate((C_word*)lf[146]+1,C_fix((C_word)SIGXCPU));
t112=C_mutate((C_word*)lf[147]+1,C_fix((C_word)SIGXFSZ));
t113=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGUSR1));
t114=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGUSR2));
t115=C_mutate((C_word*)lf[150]+1,C_fix((C_word)SIGWINCH));
t116=*((C_word*)lf[151]+1);
t117=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2219,a[2]=((C_word*)t0)[2],a[3]=t116,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 883  make-vector */
t118=*((C_word*)lf[359]+1);
((C_proc4)(void*)(*((C_word*)t118+1)))(4,t118,t117,C_fix(256),C_SCHEME_FALSE);}

/* k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2219,2,t0,t1);}
t2=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2221,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[151]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2231,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[154]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2249,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2268,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4736,tmp=(C_word)a,a+=2,tmp);
/* posix.scm: 913  set-signal-handler! */
t7=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,*((C_word*)lf[128]+1),t6);}

/* a4735 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4736(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4736,3,t0,t1,t2);}
/* posix.scm: 915  ##sys#user-interrupt-hook */
t3=*((C_word*)lf[358]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2268(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[53],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2268,2,t0,t1);}
t2=C_mutate((C_word*)lf[157]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2270,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[160]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2308,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[161]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2353,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate(&lf[162],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2407,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[163]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2410,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[167]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2473,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2536,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[172]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[173]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[174]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[175]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[176]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[177]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[178]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[179]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[180]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[181]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[182]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[183]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[184]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[185]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[186]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[187]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[188]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[189]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[190]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[191]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[193]+1,C_fix((C_word)EEXIST));
t31=C_mutate((C_word*)lf[194]+1,C_fix((C_word)EWOULDBLOCK));
t32=C_mutate((C_word*)lf[195]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2578,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[197]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2599,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[199]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2620,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[200]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2623,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[201]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2626,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[202]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2629,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[203]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2632,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2647,tmp=(C_word)a,a+=2,tmp));
t40=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2662,tmp=(C_word)a,a+=2,tmp);
t41=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2683,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[208]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2689,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[209]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2695,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2701,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2716,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2731,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2746,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[219]+1);
t49=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2777,a[2]=((C_word*)t0)[2],a[3]=t48,tmp=(C_word)a,a+=4,tmp);
t50=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posix.scm: 1185 make-string */
t51=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t51+1)))(3,t51,t49,t50);}

/* k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word ab[139],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2777,2,t0,t1);}
t2=C_mutate((C_word*)lf[220]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2778,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[222]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2817,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[225]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[226]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[227]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2836,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2873,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[236]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2888,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2899,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[238]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2910,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2952,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[246]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2973,tmp=(C_word)a,a+=2,tmp));
t14=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3009,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3071,tmp=(C_word)a,a+=2,tmp);
t16=C_mutate((C_word*)lf[250]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3089,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3104,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3119,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[256]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3141,tmp=(C_word)a,a+=2,tmp));
t20=C_mutate((C_word*)lf[258]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3166,tmp=(C_word)a,a+=2,tmp));
t21=C_mutate((C_word*)lf[260]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3203,tmp=(C_word)a,a+=2,tmp));
t22=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3226,tmp=(C_word)a,a+=2,tmp));
t23=C_mutate((C_word*)lf[263]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3237,tmp=(C_word)a,a+=2,tmp));
t24=C_mutate((C_word*)lf[264]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3249,tmp=(C_word)a,a+=2,tmp));
t25=C_mutate((C_word*)lf[265]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[266]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[267]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[268]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[269]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[270]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[271]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[272]+1,C_fix((C_word)MAP_ANON));
t33=C_mutate((C_word*)lf[273]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[274]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3332,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[280]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3390,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[282]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3422,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[283]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3428,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[284]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3434,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3440,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3451,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[289]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3468,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[292]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3496,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3524,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3552,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3560,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[302]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3579,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3582,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[309]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3635,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3656,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[312]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3683,tmp=(C_word)a,a+=2,tmp));
t51=*((C_word*)lf[315]+1);
t52=*((C_word*)lf[97]+1);
t53=*((C_word*)lf[316]+1);
t54=*((C_word*)lf[317]+1);
t55=C_mutate((C_word*)lf[318]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3695,a[2]=t51,a[3]=t52,a[4]=t53,a[5]=t54,tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[322]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3801,tmp=(C_word)a,a+=2,tmp));
t57=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3839,tmp=(C_word)a,a+=2,tmp);
t58=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3847,tmp=(C_word)a,a+=2,tmp);
t59=*((C_word*)lf[324]+1);
t60=C_mutate((C_word*)lf[325]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3855,a[2]=t59,a[3]=t58,a[4]=t57,tmp=(C_word)a,a+=5,tmp));
t61=C_mutate((C_word*)lf[327]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4019,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[329]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4089,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[330]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4092,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[331]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4095,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[332]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4098,tmp=(C_word)a,a+=2,tmp));
t66=*((C_word*)lf[322]+1);
t67=*((C_word*)lf[325]+1);
t68=*((C_word*)lf[334]+1);
t69=C_mutate((C_word*)lf[335]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4119,a[2]=t66,a[3]=t68,a[4]=t67,tmp=(C_word)a,a+=5,tmp));
t70=*((C_word*)lf[124]+1);
t71=*((C_word*)lf[322]+1);
t72=*((C_word*)lf[244]+1);
t73=*((C_word*)lf[48]+1);
t74=*((C_word*)lf[335]+1);
t75=*((C_word*)lf[50]+1);
t76=*((C_word*)lf[51]+1);
t77=*((C_word*)lf[339]+1);
t78=*((C_word*)lf[340]+1);
t79=*((C_word*)lf[55]+1);
t80=*((C_word*)lf[327]+1);
t81=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4165,a[2]=t80,tmp=(C_word)a,a+=3,tmp);
t82=C_mutate((C_word*)lf[341]+1,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4185,a[2]=t71,a[3]=t72,a[4]=t75,a[5]=t77,a[6]=t78,a[7]=t73,a[8]=t81,a[9]=t70,tmp=(C_word)a,a+=10,tmp));
t83=*((C_word*)lf[318]+1);
t84=*((C_word*)lf[319]+1);
t85=*((C_word*)lf[316]+1);
t86=*((C_word*)lf[101]+1);
t87=C_mutate((C_word*)lf[349]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4493,a[2]=t86,a[3]=t85,a[4]=t83,a[5]=t84,tmp=(C_word)a,a+=6,tmp));
t88=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4716,tmp=(C_word)a,a+=2,tmp));
t89=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t89+1)))(2,t89,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4716(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4716,3,t0,t1,t2);}
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4712,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
/* ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t3);}
else{
t5=t4;
f_4712(2,t5,C_SCHEME_FALSE);}}

/* k4710 in set-root-directory! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4712(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4712,2,t0,t1);}
t2=(C_word)stub926(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1811 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[356],lf[357],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4493(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4493r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4493r(t0,t1,t2,t3,t4);}}

static void f_4493r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4495,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4631,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4636,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4641,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action884915 */
t9=t8;
f_4641(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id885913 */
t11=t7;
f_4636(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit886910 */
t13=t6;
f_4631(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body882888 */
t15=t5;
f_4495(t15,t1,t9,t11,t13);}}}}

/* def-action884 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4641(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4641,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4647,tmp=(C_word)a,a+=2,tmp);
/* def-id885913 */
t3=((C_word*)t0)[2];
f_4636(t3,t1,t2);}

/* a4646 in def-action884 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4647(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4647,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id885 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4636(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4636,NULL,3,t0,t1,t2);}
/* def-limit886910 */
t3=((C_word*)t0)[2];
f_4631(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit886 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4631(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4631,NULL,4,t0,t1,t2,t3);}
/* body882888 */
t4=((C_word*)t0)[2];
f_4495(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4495(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4495,NULL,5,t0,t1,t2,t3,t4);}
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4499,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t6,a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],tmp=(C_word)a,a+=12,tmp);
t8=t4;
if(C_truep(t8)){
t9=(C_word)C_fixnump(t4);
t10=t7;
f_4499(t10,(C_truep(t9)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4626,a[2]=t4,a[3]=t6,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t9=t7;
f_4499(t9,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4618,tmp=(C_word)a,a+=2,tmp));}}

/* f_4618 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4618(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4618,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_4626 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4626(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4626,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4499(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4499,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4610,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4509,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4606,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1783 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[355]);}

/* k4604 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1783 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4509,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4511,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4511(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4511(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4511,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4530,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posix.scm: 1789 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4530,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4586,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posix.scm: 1790 pathname-file */
t3=*((C_word*)lf[354]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4592,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1796 pproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k4590 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4592,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4599,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1796 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posix.scm: 1797 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4511(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k4597 in k4590 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1796 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4511(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4586,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[350]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[351]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix.scm: 1790 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4511(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4545,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix.scm: 1791 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4545,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4555,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4557,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4562,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4576,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1793 ##sys#dynamic-wind */
t11=*((C_word*)lf[353]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posix.scm: 1795 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4511(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a4575 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4576,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4561 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4562,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4570,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4574,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1794 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[352]);}

/* k4572 in a4561 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1794 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4568 in a4561 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1794 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4511(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a4556 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4557,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4553 in k4543 in k4584 in k4528 in loop in k4507 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1792 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4511(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_4610 in k4497 in body882 in find-files in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4610(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4610,3,t0,t1,t2);}
/* posix.scm: 1781 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4185(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4185r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4185r(t0,t1,t2,t3);}}

static void f_4185r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4187,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4443,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4448,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args794859 */
t7=t6;
f_4448(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env795857 */
t9=t5;
f_4443(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body792797 */
t11=t4;
f_4187(t11,t1,t7,t9);}}}

/* def-args794 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4448(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4448,NULL,2,t0,t1);}
/* def-env795857 */
t2=((C_word*)t0)[2];
f_4443(t2,t1,C_SCHEME_FALSE);}

/* def-env795 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4443(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4443,NULL,3,t0,t1,t2);}
/* body792797 */
t3=((C_word*)t0)[2];
f_4187(t3,t1,t2,C_SCHEME_FALSE);}

/* body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4187(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4187,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4193,a[2]=((C_word*)t0)[10],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4199,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
/* posix.scm: 1684 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}

/* a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4199,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4205,a[2]=((C_word*)t0)[12],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4211,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=t3,tmp=(C_word)a,a+=14,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}

/* a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4211(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4211,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4215,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=t1,a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[13],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4392,a[2]=((C_word*)t0)[13],a[3]=t2,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[10],a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[12],a[10]=((C_word*)t0)[5],tmp=(C_word)a,a+=11,tmp);
/* posix.scm: 1687 process-fork */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}

/* a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4392(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4392,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4396,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posix.scm: 1689 file-close */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4396,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4399,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posix.scm: 1690 file-close */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4399,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4402,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[225]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f_4402(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4439,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1692 duplicate-fileno */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[225]+1));}}

/* k4437 in k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1693 file-close */
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4400 in k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4402,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4405,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[226]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f_4405(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4430,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1695 duplicate-fileno */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[226]+1));}}

/* k4428 in k4400 in k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1696 file-close */
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4403 in k4400 in k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4405,2,t0,t1);}
if(C_truep(((C_word*)t0)[5])){
/* posix.scm: 1698 process-execute */
t2=*((C_word*)lf[325]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4414,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1699 getenv */
t3=*((C_word*)lf[334]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[348]);}}

/* k4412 in k4403 in k4400 in k4397 in k4394 in a4391 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4414,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[346]);
t3=(C_word)C_a_i_list(&a,2,lf[347],((C_word*)t0)[4]);
/* posix.scm: 1700 process-execute */
t4=*((C_word*)lf[325]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t2,t3,((C_word*)t0)[2]);}

/* k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4215(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4215,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4218,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
/* posix.scm: 1703 file-close */
t7=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[2]);}

/* k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4218(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4218,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4221,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posix.scm: 1704 file-close */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4221,2,t0,t1);}
t2=f_1099(((C_word*)t0)[13]);
t3=f_1099(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4234,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posix.scm: 1708 make-string */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[41],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4234,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4236,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4278,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4347,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4363,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4379,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1727 make-input-port */
t11=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}

/* a4378 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4379,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4383,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1737 file-close */
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4381 in a4378 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posix.scm: 1739 wait */
t3=((C_word*)t0)[4];
f_4165(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4362 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4363,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)stub779(C_SCHEME_UNDEFINED,t3);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_eqp(C_fix(1),t4));}}

/* a4346 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4347,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4351,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 1729 fetch */
t3=((C_word*)t0)[2];
f_4236(t3,t2);}

/* k4349 in a4346 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4278(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4278,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4282,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4284,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4334,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1740 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t3,t4);}

/* a4333 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4334,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4338,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1756 file-close */
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4336 in a4333 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posix.scm: 1758 wait */
t3=((C_word*)t0)[4];
f_4165(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4283 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4284(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4284,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4293,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_4293(t10,t1);}

/* loop in a4283 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4293(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4293,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4309,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1748 yield */
f_1124(t5);}
else{
/* posix.scm: 1750 posix-error */
t5=lf[4];
f_1107(t5,t1,lf[44],lf[345],((C_word*)t0)[2],(C_word)C_a_i_list(&a,1,((C_word*)t0)[6]));}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4325,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* substring */
t5=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4323 in loop in a4283 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
/* posix.scm: 1754 loop */
t5=((C_word*)((C_word*)t0)[3])[1];
f_4293(t5,((C_word*)t0)[2]);}

/* k4307 in loop in a4283 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1749 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4293(t2,((C_word*)t0)[2]);}

/* k4280 in k4276 in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1707 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4236(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4236,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4246,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4250,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_4250(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4250(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4250,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4266,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1718 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[343]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[10]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
/* posix.scm: 1721 posix-error */
t5=lf[4];
f_1107(t5,t1,lf[44],lf[341],lf[344],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]));}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4264 in loop in fetch in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4266,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4269,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1719 yield */
f_1124(t2);}

/* k4267 in k4264 in loop in fetch in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1720 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4250(t2,((C_word*)t0)[2]);}

/* k4244 in fetch in k4232 in k4219 in k4216 in k4213 in a4210 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4204 in a4198 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4205,2,t0,t1);}
/* posix.scm: 1685 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a4192 in body792 in process in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4193,2,t0,t1);}
/* posix.scm: 1684 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* wait in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_4165(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4165,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4171,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4177,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t3,t4);}

/* a4176 in wait in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4177(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4177,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1681 ##sys#error */
t5=*((C_word*)lf[105]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[341],lf[342],((C_word*)t0)[2],t4);}}

/* a4170 in wait in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4171,2,t0,t1);}
/* posix.scm: 1679 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4119(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4119r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4119r(t0,t1,t2,t3);}}

static void f_4119r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4126,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1646 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k4124 in process-run in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4126,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
/* posix.scm: 1648 process-execute */
t3=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4141,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1650 getenv */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[338]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4139 in k4124 in process-run in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4141,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[336]);
t3=(C_word)C_a_i_list(&a,2,lf[337],((C_word*)t0)[4]);
/* posix.scm: 1651 process-execute */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4098(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4098r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4098r(t0,t1,t2,t3);}}

static void f_4098r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_kill(t2,t5);
t7=(C_word)C_eqp(t6,C_fix(-1));
if(C_truep(t7)){
/* posix.scm: 1638 posix-error */
t8=lf[4];
f_1107(t8,t1,lf[155],lf[332],lf[333],(C_word)C_a_i_list(&a,2,t2,t5));}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

/* sleep in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4095(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4095,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub749(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4092,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub746(C_SCHEME_UNDEFINED));}

/* current-process-id in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4089,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub744(C_SCHEME_UNDEFINED));}

/* process-wait in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_4019(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4019r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4019r(t0,t1,t2);}}

static void f_4019r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(3);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_waitpid(t11,t12);
t14=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t15=(C_word)C_eqp(t13,C_fix(-1));
if(C_truep(t15)){
/* posix.scm: 1618 posix-error */
t16=lf[4];
f_1107(t16,t1,lf[155],lf[327],lf[328],(C_word)C_a_i_list(&a,1,t11));}
else{
t16=(C_truep(t14)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posix.scm: 1619 values */
C_values(5,0,t1,t13,t14,t16);}}

/* process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3855(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_3855r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3855r(t0,t1,t2,t3);}}

static void f_3855r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3857,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3969,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3974,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist694724 */
t7=t6;
f_3974(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist695722 */
t9=t5;
f_3969(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body692697 */
t11=t4;
f_3857(t11,t1,t7,t9);}}}

/* def-arglist694 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3974(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3974,NULL,2,t0,t1);}
/* def-envlist695722 */
t2=((C_word*)t0)[2];
f_3969(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist695 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3969(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3969,NULL,3,t0,t1,t2);}
/* body692697 */
t3=((C_word*)t0)[2];
f_3857(t3,t1,t2,C_SCHEME_FALSE);}

/* body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3857(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3857,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3861,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t3,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 1581 pathname-strip-directory */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}

/* k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3861,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_3839(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3869,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_3869(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do701 in k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3869(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3869,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_3839(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3882,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3912,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t7=t5;
f_3882(t7,f_3912(t6,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_3882(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_block_size(t4);
t6=f_3839(t3,t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t13=t1;
t14=t7;
t15=t8;
t1=t13;
t2=t14;
t3=t15;
goto loop;}}

/* do705 in do701 in k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_3912(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
loop:
if(C_truep((C_word)C_i_nullp(t1))){
return(f_3847(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_u_i_car(t1);
t4=(C_word)C_block_size(t3);
t5=f_3847(t2,t3,t4);
t6=(C_word)C_slot(t1,C_fix(1));
t7=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t9=t6;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}

/* k3880 in do701 in k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3882(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3882,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3885,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3907,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1594 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3905 in k3880 in do701 in k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1594 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3883 in k3880 in do701 in k3859 in body692 in process-execute in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3885,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub673(C_SCHEME_UNDEFINED);
t5=(C_word)stub685(C_SCHEME_UNDEFINED);
/* posix.scm: 1601 posix-error */
t6=lf[4];
f_1107(t6,((C_word*)t0)[3],lf[155],lf[325],lf[326],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_3847(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub678(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* setarg in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_3839(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub666(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-fork in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3801(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3801r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3801r(t0,t1,t2);}}

static void f_3801r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub649(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posix.scm: 1566 posix-error */
t5=lf[4];
f_1107(t5,t1,lf[155],lf[322],lf[323],C_SCHEME_END_OF_LIST);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3823,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_slot(t2,C_fix(0));
t9=t8;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k3821 in process-fork in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3823(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3823,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3827,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_3827 in k3821 in process-fork in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3827(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3827,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub654(C_SCHEME_UNDEFINED,t2));}

/* glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3695(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3695r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3695r(t0,t1,t2);}}

static void f_3695r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3701,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3701(t6,t1,t2);}

/* conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3701(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3701,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3716,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3722,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3722(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3722,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3726,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3793,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[321]);
/* posix.scm: 1550 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3791 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1550 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3726,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3733,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[320]);
/* posix.scm: 1551 directory */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* k3731 in k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3733,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3735,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3735(t5,((C_word*)t0)[2],t1);}

/* loop in k3731 in k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3735(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3735,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[7],C_fix(1));
/* posix.scm: 1552 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_3701(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3752,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posix.scm: 1553 string-match */
t5=*((C_word*)lf[319]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3750 in loop in k3731 in k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3752(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3752,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3762,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posix.scm: 1554 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posix.scm: 1555 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3735(t3,((C_word*)t0)[6],t2);}}

/* k3760 in k3750 in loop in k3731 in k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3762,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3766,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 1554 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3735(t4,t2,t3);}

/* k3764 in k3760 in k3750 in loop in k3731 in k3724 in a3721 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3766,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3715 in conc in glob in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3716(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3716,2,t0,t1);}
/* posix.scm: 1549 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3683,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3687,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub612(t3),C_fix(0));}

/* k3685 in get-host-name in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3687,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3690,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3690(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1533 posix-error */
t3=lf[4];
f_1107(t3,t2,lf[313],lf[312],lf[314],C_SCHEME_END_OF_LIST);}}

/* k3688 in k3685 in get-host-name in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3656(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3656,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3660,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_slot(t2,C_fix(7));
t5=(C_word)C_eqp(lf[82],t4);
t6=(C_truep(t5)?(C_word)C_tty_portp(t2):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t3;
f_3660(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1522 ##sys#error */
t7=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t3,lf[310],lf[311],t2);}}

/* k3658 in terminal-name in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3660(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3660,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub605(t4,t3),C_fix(0));}

/* terminal-port? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3635(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3635,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3639,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1513 ##sys#peek-unsigned-integer */
t4=*((C_word*)lf[243]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

/* k3637 in terminal-port? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3639(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3582(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3582r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3582r(t0,t1,t2,t3,t4);}}

static void f_3582r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(5);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)BUFSIZ));
t7=t3;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3589,a[2]=t1,a[3]=t6,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(C_word)C_eqp(t7,lf[305]);
if(C_truep(t9)){
t10=t8;
f_3589(2,t10,C_fix((C_word)_IOFBF));}
else{
t10=(C_word)C_eqp(t7,lf[306]);
if(C_truep(t10)){
t11=t8;
f_3589(2,t11,C_fix((C_word)_IOLBF));}
else{
t11=(C_word)C_eqp(t7,lf[307]);
if(C_truep(t11)){
t12=t8;
f_3589(2,t12,C_fix((C_word)_IONBF));}
else{
/* posix.scm: 1500 ##sys#error */
t12=*((C_word*)lf[105]+1);
((C_proc6)(void*)(*((C_word*)t12+1)))(6,t12,t8,lf[303],lf[308],t3,t2);}}}}

/* k3587 in set-buffering-mode! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[82],t2);
t4=(C_truep(t3)?(C_word)C_setvbuf(((C_word*)t0)[4],t1,((C_word*)t0)[3]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
/* posix.scm: 1506 ##sys#error */
t5=*((C_word*)lf[105]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,((C_word*)t0)[2],lf[303],lf[304],((C_word*)t0)[4],t1,((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3579(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3579,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub591(C_SCHEME_UNDEFINED,t2));}

/* _exit in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3560(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3560r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3560r(t0,t1,t2);}}

static void f_3560r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3564,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1482 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[301]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3562 in _exit in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=t4;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub585(C_SCHEME_UNDEFINED,t3));}

/* local-timezone-abbreviation in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3552,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub580(t2),C_fix(0));}

/* utc-time->seconds in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3524(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3524,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[296]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3531,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1460 ##sys#error */
t6=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[296],lf[298],t2);}
else{
t6=t4;
f_3531(2,t6,C_SCHEME_UNDEFINED);}}

/* k3529 in utc-time->seconds in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posix.scm: 1462 ##sys#cons-flonum */
t2=*((C_word*)lf[293]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posix.scm: 1463 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[296],lf[297],((C_word*)t0)[3]);}}

/* local-time->seconds in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3496(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3496,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[292]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3503,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1453 ##sys#error */
t6=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[292],lf[295],t2);}
else{
t6=t4;
f_3503(2,t6,C_SCHEME_UNDEFINED);}}

/* k3501 in local-time->seconds in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posix.scm: 1455 ##sys#cons-flonum */
t2=*((C_word*)lf[293]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posix.scm: 1456 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[292],lf[294],((C_word*)t0)[3]);}}

/* time->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3468(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3468,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[289]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3475,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posix.scm: 1446 ##sys#error */
t6=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[289],lf[291],t2);}
else{
t6=t4;
f_3475(2,t6,C_SCHEME_UNDEFINED);}}

/* k3473 in time->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3475(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3475,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3478,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub565(t4,t3),C_fix(0));}

/* k3476 in k3473 in time->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3478,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3481,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3481(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1448 ##sys#error */
t3=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[289],lf[290],((C_word*)t0)[2]);}}

/* k3479 in k3476 in k3473 in time->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3481(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3451(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3451,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3455,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub556(t5,t4),C_fix(0));}

/* k3453 in seconds->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3455,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3458,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3458(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1439 ##sys#error */
t3=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[287],lf[288],((C_word*)t0)[2]);}}

/* k3456 in k3453 in seconds->string in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3440(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3440,3,t0,t1,t2);}
/* posix.scm: 1433 ##sys#decode-seconds */
t3=*((C_word*)lf[285]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3434(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3434,3,t0,t1,t2);}
/* posix.scm: 1429 ##sys#decode-seconds */
t3=*((C_word*)lf[285]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3428(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3428,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[275]));}

/* memory-mapped-file-pointer in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3422(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3422,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3390(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3390r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3390r(t0,t1,t2,t3);}}

static void f_3390r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_truep(t6)?(C_word)C_i_foreign_pointer_argumentp(t6):C_SCHEME_FALSE);
t8=(C_word)stub529(C_SCHEME_UNDEFINED,t7,t5);
t9=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t9)){
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1416 posix-error */
t10=lf[4];
f_1107(t10,t1,lf[44],lf[280],lf[281],(C_word)C_a_i_list(&a,2,t2,t5));}}

/* map-file-to-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3332(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_3332r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_3332r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f_3332r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3336,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_3336(2,t10,t2);}
else{
/* posix.scm: 1401 ##sys#null-pointer */
t10=*((C_word*)lf[279]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k3334 in map-file-to-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3336,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3342,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_3342(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1404 ##sys#signal-hook */
t6=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[53],lf[274],lf[278],t1);}}

/* k3340 in k3334 in map-file-to-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3342(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3342,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub504(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3348,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3361,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
/* posix.scm: 1406 ##sys#pointer->address */
t12=*((C_word*)lf[277]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k3359 in k3340 in k3334 in map-file-to-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3361,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posix.scm: 1407 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[8],lf[44],lf[274],lf[276],(C_word)C_a_i_list(&a,6,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[8];
f_3348(2,t3,C_SCHEME_UNDEFINED);}}

/* k3346 in k3340 in k3334 in map-file-to-memory in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3348,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[275],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3249,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3255,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_3255(t5,t1,C_fix(0));}

/* loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3255(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3255,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3259,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub482(t5,t4),C_fix(0));}

/* k3257 in loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3259(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3259,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3267,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_3267(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3257 in loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3267(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3267,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3293,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 1365 ##sys#substring */
t5=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posix.scm: 1368 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3291 in scan in k3257 in loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3293,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3297,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posix.scm: 1366 ##sys#substring */
t5=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k3295 in k3291 in scan in k3257 in loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3297,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3285,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 1367 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3255(t5,t3,t4);}

/* k3283 in k3295 in k3291 in scan in k3257 in loop in current-environment in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3285,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3237,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3242,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1354 ##sys#make-c-string */
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k3240 in unsetenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3226(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3226,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3231,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1349 ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3229 in setenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3231,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3235,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1349 ##sys#make-c-string */
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3233 in k3229 in setenv in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3203(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3203,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3207,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3224,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1338 ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3222 in fifo? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1338 ##sys#file-info */
t2=*((C_word*)lf[102]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3205 in fifo? in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3207,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posix.scm: 1341 posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[3],lf[44],lf[260],lf[261],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-fifo in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3166(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3166r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3166r(t0,t1,t2,t3);}}

static void f_3166r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3170,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t5=t4;
f_3170(t5,(C_word)C_slot(t3,C_fix(0)));}
else{
t5=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t6=t4;
f_3170(t6,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t5));}}

/* k3168 in create-fifo in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3170(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3170,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3188,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1332 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3186 in k3168 in create-fifo in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1332 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3182 in k3168 in create-fifo in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3184,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1333 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[258],lf[259],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3141(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3141,3,t0,t1,t2);}
t3=(C_word)C_slot(t2,C_fix(2));
t4=(C_word)C_slot(t2,C_fix(3));
t5=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_flock_lock(t6);
if(C_truep((C_word)C_fixnum_lessp(t7,C_fix(0)))){
/* posix.scm: 1318 posix-error */
t8=lf[4];
f_1107(t8,t1,lf[44],lf[256],lf[257],(C_word)C_a_i_list(&a,1,t2));}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3119(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3119r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3119r(t0,t1,t2,t3);}}

static void f_3119r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3123,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1309 setup */
f_3009(t4,t2,t3);}

/* k3121 in file-test-lock in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posix.scm: 1311 err */
f_3071(((C_word*)t0)[3],lf[255],t1,lf[254]);}}

/* file-lock/blocking in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3104(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3104r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3104r(t0,t1,t2,t3);}}

static void f_3104r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3108,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1303 setup */
f_3009(t4,t2,t3);}

/* k3106 in file-lock/blocking in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posix.scm: 1305 err */
f_3071(((C_word*)t0)[2],lf[253],t1,lf[252]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3089(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3089r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3089r(t0,t1,t2,t3);}}

static void f_3089r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3093,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1297 setup */
f_3009(t4,t2,t3);}

/* k3091 in file-lock in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_3093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posix.scm: 1299 err */
f_3071(((C_word*)t0)[2],lf[251],t1,lf[250]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3071(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3071,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posix.scm: 1294 posix-error */
t8=lf[4];
f_1107(t8,t1,lf[44],t4,t2,(C_word)C_a_i_list(&a,3,t5,t6,t7));}

/* setup in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3009(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3009,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(0):(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:(C_word)C_u_i_car(t7));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(C_word)C_i_nullp(t7);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t7,C_fix(1)));
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3028,a[2]=t1,a[3]=t11,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t15=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)t11)[1]);
if(C_truep(t15)){
t16=C_set_block_item(t11,0,C_fix(0));
t17=t14;
f_3028(t17,t16);}
else{
t16=t14;
f_3028(t16,C_SCHEME_UNDEFINED);}}

/* k3026 in setup in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_3028(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3028,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[249],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2973(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2973,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2987,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2994,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2998,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1269 ##sys#expand-home-path */
t7=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t5=t4;
f_2987(2,t5,(C_word)C_ftruncate(t2,t3));}
else{
/* posix.scm: 1271 ##sys#error */
t5=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,lf[246],lf[248],t2);}}}

/* k2996 in file-truncate in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1269 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2992 in file-truncate in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2994(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2987(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k2985 in file-truncate in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2987(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2987,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 1273 posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[4],lf[44],lf[246],lf[247],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2952(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2952r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2952r(t0,t1,t2,t3);}}

static void f_2952r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2956,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t5=t4;
f_2956(t5,(C_word)C_dup(t2));}
else{
t5=(C_word)C_slot(t3,C_fix(0));
t6=t4;
f_2956(t6,(C_word)C_dup2(t2,t5));}}

/* k2954 in duplicate-fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2956(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2956,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2959,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 1257 posix-error */
t3=lf[4];
f_1107(t3,t2,lf[44],lf[244],lf[245],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_2959(2,t3,C_SCHEME_UNDEFINED);}}

/* k2957 in k2954 in duplicate-fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2959(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2910(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2910,3,t0,t1,t2);}
t3=(C_word)C_slot(t2,C_fix(7));
t4=(C_word)C_eqp(lf[239],t3);
if(C_truep(t4)){
/* posix.scm: 1240 ##sys#tcp-port->fileno */
t5=*((C_word*)lf[240]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t2);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2946,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1241 ##sys#peek-unsigned-integer */
t6=*((C_word*)lf[243]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,C_fix(0));}}

/* k2944 in port->fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2946(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2946,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posix.scm: 1246 posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[3],lf[53],lf[238],lf[241],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2929,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1244 posix-error */
t4=lf[4];
f_1107(t4,t3,lf[44],lf[238],lf[242],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_2929(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2927 in k2944 in port->fileno in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2899(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2899r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2899r(t0,t1,t2,t3);}}

static void f_2899r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2908,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1235 mode */
f_2836(t4,C_SCHEME_FALSE,t3);}

/* k2906 in open-output-file* in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2908,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posix.scm: 1235 check */
f_2873(((C_word*)t0)[2],lf[237],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2888(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2888r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2888r(t0,t1,t2,t3);}}

static void f_2888r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2897,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1231 mode */
f_2836(t4,C_SCHEME_TRUE,t3);}

/* k2895 in open-input-file* in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2897,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posix.scm: 1231 check */
f_2873(((C_word*)t0)[2],lf[236],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2873(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2873,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posix.scm: 1224 posix-error */
t6=lf[4];
f_1107(t6,t1,lf[44],t2,lf[234],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2886,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1225 ##sys#make-port */
t7=*((C_word*)lf[108]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[109]+1),lf[235],lf[82]);}}

/* k2884 in check in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2836(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2836,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2844,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[228]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posix.scm: 1218 ##sys#error */
t8=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[229],t5);}
else{
t8=t4;
f_2844(2,t8,lf[230]);}}
else{
/* posix.scm: 1219 ##sys#error */
t7=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[231],t5);}}
else{
t5=t4;
f_2844(2,t5,(C_truep(t2)?lf[232]:lf[233]));}}

/* k2842 in mode in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1214 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2817(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2817,4,t0,t1,t2,t3);}
t4=t2;
t5=t3;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2806,a[2]=t5,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t7=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}
else{
t7=t6;
f_2806(2,t7,C_SCHEME_FALSE);}}

/* k2804 in file-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2806(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2806,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2810,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_2810(2,t3,C_SCHEME_FALSE);}}

/* k2808 in k2804 in file-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2810(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2810,2,t0,t1);}
t2=(C_word)stub380(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1199 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[4],lf[44],lf[223],lf[224],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2778(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2778,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2783,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2799,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1188 ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2797 in read-symbolic-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1188 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2781 in read-symbolic-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2783,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2786,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1190 posix-error */
t4=lf[4];
f_1107(t4,t3,lf[44],lf[220],lf[221],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_2786(2,t4,C_SCHEME_UNDEFINED);}}

/* k2784 in k2781 in read-symbolic-link in k2775 in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1191 substring */
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2746(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2746,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2761,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2773,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1176 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2771 in create-symbolic-link in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1176 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2759 in create-symbolic-link in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2761,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2765,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2769,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1177 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2767 in k2759 in create-symbolic-link in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1177 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2763 in k2759 in create-symbolic-link in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2765,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1179 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[4],lf[44],lf[217],lf[218],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2731(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2731,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2741,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1164 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2739 in set-process-group-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1165 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[214],lf[215],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* process-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2716(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2716,3,t0,t1,t2);}
t3=(C_word)C_getpgid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2720,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2726,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1156 ##sys#update-errno */
t6=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t4;
f_2720(2,t5,C_SCHEME_UNDEFINED);}}

/* k2724 in process-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1157 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[212],lf[213],((C_word*)t0)[2]);}

/* k2718 in process-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2720(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-session in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2701,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2705,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2711,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1148 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2705(2,t4,C_SCHEME_UNDEFINED);}}

/* k2709 in create-session in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1149 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[210],lf[211]);}

/* k2703 in create-session in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2695(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2695,3,t0,t1,t2);}
/* posix.scm: 1143 check */
f_2662(t1,t2,C_fix((C_word)X_OK));}

/* file-write-access? in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2689(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2689,3,t0,t1,t2);}
/* posix.scm: 1142 check */
f_2662(t1,t2,C_fix((C_word)W_OK));}

/* file-read-access? in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2683(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2683,3,t0,t1,t2);}
/* posix.scm: 1141 check */
f_2662(t1,t2,C_fix((C_word)R_OK));}

/* check in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2662(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2662,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2677,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2681,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1138 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2679 in check in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1138 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2675 in check in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2677,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2669,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2669(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1139 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2667 in k2675 in check in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2669(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-group-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2647(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2647,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2657,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1128 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2655 in set-group-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1129 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[203],lf[206],((C_word*)t0)[2]);}

/* set-user-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2632(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2632,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2642,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1122 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2640 in set-user-id! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1123 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[203],lf[204],((C_word*)t0)[2]);}

/* current-effective-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2629,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub342(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2626,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub340(C_SCHEME_UNDEFINED));}

/* current-group-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2623,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub338(C_SCHEME_UNDEFINED));}

/* current-user-id in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2620,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub336(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2599(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2599,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2614,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2618,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1111 ##sys#expand-home-path */
t7=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2616 in change-file-owner in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1111 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2612 in change-file-owner in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2614,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1112 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[197],lf[198],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2578(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2578,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2593,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2597,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1103 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2595 in change-file-mode in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1103 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2591 in change-file-mode in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2593,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix.scm: 1104 posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[195],lf[196],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2536(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2536,4,t0,t1,t2,t3);}
t4=t2;
t5=t3;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2532,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t7=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}
else{
t7=t6;
f_2532(2,t7,C_SCHEME_FALSE);}}

/* k2530 in initialize-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2532,2,t0,t1);}
t2=(C_word)stub314(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[5]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2546,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 1034 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2544 in k2530 in initialize-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1035 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[170],lf[171],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2473(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2473,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2477,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2407(t4);
if(C_truep(t5)){
t6=t3;
f_2477(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1017 ##sys#error */
t6=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[167],lf[169]);}}

/* k2475 in set-groups! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2477,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2482,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2482(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do302 in k2475 in set-groups! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2482(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2482,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2498,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 1022 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_set_gid(t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t10=t1;
t11=t6;
t12=t7;
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* k2496 in do302 in k2475 in set-groups! in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2498(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1023 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[167],lf[168],((C_word*)t0)[2]);}

/* get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2410,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2414,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2468,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1003 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2414(2,t4,C_SCHEME_UNDEFINED);}}

/* k2466 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1004 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[163],lf[166]);}

/* k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2414,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2417,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2407(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2417(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 1006 ##sys#error */
t4=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[163],lf[165]);}}

/* k2415 in k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2417,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2420,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)stub284(C_SCHEME_UNDEFINED,((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2449,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 1008 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_2420(2,t4,C_SCHEME_UNDEFINED);}}

/* k2447 in k2415 in k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 1009 ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[163],lf[164]);}

/* k2418 in k2415 in k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2420(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2420,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2425,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2425(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2418 in k2415 in k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2425(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2425,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2439,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posix.scm: 1013 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2437 in loop in k2418 in k2415 in k2412 in get-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2439,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_2407(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub288(C_SCHEME_UNDEFINED,t1));}

/* group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2353(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2353,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2357,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2357(t4,(C_word)C_getgrgid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2402,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 978  ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

/* k2400 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2357(t2,(C_word)C_getgrnam(t1));}

/* k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2357(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2357,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2367,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2367,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2371,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2369 in k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2371,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2375,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2377,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_2377(t6,t2,C_fix(0));}

/* rec in k2369 in k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2377(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2377,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2381,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub273(t5,t4),C_fix(0));}

/* k2379 in rec in k2369 in k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2381(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2381,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2391,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 986  rec */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2377(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2389 in k2379 in rec in k2369 in k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2391,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2373 in k2369 in k2365 in k2355 in group-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2375,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,4,((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1));}

/* user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2308(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2308,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2312,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2312(t4,(C_word)C_getpwuid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2345,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 955  ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

/* k2343 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2312(t2,(C_word)C_getpwnam(t1));}

/* k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_2312(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2312,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2322,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2320 in k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2322,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2326,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2324 in k2320 in k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2326(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2326,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2330,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2328 in k2324 in k2320 in k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2330,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2334,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2332 in k2328 in k2324 in k2320 in k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2334,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2338,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2336 in k2332 in k2328 in k2324 in k2320 in k2310 in user-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2338,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2270,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2274,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2303,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 934  ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2274(2,t3,C_SCHEME_UNDEFINED);}}

/* k2301 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2303(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 935  ##sys#error */
t2=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[157],lf[159]);}

/* k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2274,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2281,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2279 in k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2281,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2285,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2283 in k2279 in k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2285,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2289,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2287 in k2283 in k2279 in k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2289,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2293,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2291 in k2287 in k2283 in k2279 in k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2293,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2297,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[158]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2295 in k2291 in k2287 in k2283 in k2279 in k2272 in system-information in k2266 in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2297,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* set-signal-mask! in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2249(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2249,3,t0,t1,t2);}
t3=(C_word)C_sigemptyset(C_fix(0));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2253,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2264,tmp=(C_word)a,a+=2,tmp);
/* for-each */
t6=*((C_word*)lf[64]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,t2);}

/* a2263 in set-signal-mask! in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2264(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2264,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_sigaddset(t2));}

/* k2251 in set-signal-mask! in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
/* posix.scm: 908  posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[2],lf[155],lf[154],lf[156],C_SCHEME_END_OF_LIST);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2231(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2231,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2241,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 894  h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posix.scm: 896  oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k2239 in ##sys#interrupt-hook in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 895  ##sys#context-switch */
t2=*((C_word*)lf[153]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2217 in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2221(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2221,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?t2:C_SCHEME_FALSE);
t5=(C_word)C_establish_signal_handler(t2,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2178,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2182,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posix.scm: 820  posix-error */
t3=lf[4];
f_1107(t3,t2,lf[44],lf[124],lf[125],C_SCHEME_END_OF_LIST);}
else{
t3=t2;
f_2182(2,t3,C_SCHEME_UNDEFINED);}}

/* k2180 in create-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2182(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 821  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2158(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2158r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2158r(t0,t1,t2,t3,t4);}}

static void f_2158r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[123]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2162,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2160 in with-output-to-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2162,2,t0,t1);}
t2=C_mutate((C_word*)lf[123]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2168,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 808  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2167 in k2160 in with-output-to-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2168(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2168r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2168r(t0,t1,t2);}}

static void f_2168r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2172,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 810  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2170 in a2167 in k2160 in with-output-to-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[123]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2138(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2138r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2138r(t0,t1,t2,t3,t4);}}

static void f_2138r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[121]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2142,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2140 in with-input-from-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2142(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2142,2,t0,t1);}
t2=C_mutate((C_word*)lf[121]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2148,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 798  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2147 in k2140 in with-input-from-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2148(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2148r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2148r(t0,t1,t2);}}

static void f_2148r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2152,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 800  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2150 in a2147 in k2140 in with-input-from-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[121]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2114(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2114r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2114r(t0,t1,t2,t3,t4);}}

static void f_2114r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2118,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2116 in call-with-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2118,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2123,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2129,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 788  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2128 in k2116 in call-with-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2129(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2129r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2129r(t0,t1,t2);}}

static void f_2129r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2133,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 791  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2131 in a2128 in k2116 in call-with-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2122 in k2116 in call-with-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2123,2,t0,t1);}
/* posix.scm: 789  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2090(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2090r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2090r(t0,t1,t2,t3,t4);}}

static void f_2090r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2094,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2092 in call-with-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2094,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2099,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2105,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 780  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2104 in k2092 in call-with-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2105(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2105r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2105r(t0,t1,t2);}}

static void f_2105r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2109,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 783  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2107 in a2104 in k2092 in call-with-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2098 in k2092 in call-with-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2099,2,t0,t1);}
/* posix.scm: 781  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2077(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2077,3,t0,t1,t2);}
t3=(C_word)close_pipe(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2081,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posix.scm: 769  posix-error */
t6=lf[4];
f_1107(t6,t4,lf[44],lf[115],lf[116],(C_word)C_a_i_list(&a,1,t2));}
else{
t6=t4;
f_2081(2,t6,C_SCHEME_UNDEFINED);}}

/* k2079 in close-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2044(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2044r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2044r(t0,t1,t2,t3);}}

static void f_2044r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1978(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2055,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[104]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2062,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 762  ##sys#make-c-string */
t8=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[112]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2072,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 763  ##sys#make-c-string */
t9=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posix.scm: 764  badmode */
f_1990(t5,t4);}}}

/* k2070 in open-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2072,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2055(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2060 in open-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2062,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2055(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2053 in open-output-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 758  check */
f_1996(((C_word*)t0)[3],lf[113],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2011(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2011r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2011r(t0,t1,t2,t3);}}

static void f_2011r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1978(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2022,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[104]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2029,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 751  ##sys#make-c-string */
t8=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[112]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2039,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 752  ##sys#make-c-string */
t9=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posix.scm: 753  badmode */
f_1990(t5,t4);}}}

/* k2037 in open-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2039,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2022(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2027 in open-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2029,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2022(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2020 in open-input-pipe in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 747  check */
f_1996(((C_word*)t0)[3],lf[111],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1996(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1996,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posix.scm: 739  posix-error */
t6=lf[4];
f_1107(t6,t1,lf[44],t2,lf[107],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2009,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 740  ##sys#make-port */
t7=*((C_word*)lf[108]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[109]+1),lf[110],lf[82]);}}

/* k2007 in check in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_2009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1990(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1990,NULL,2,t1,t2);}
/* posix.scm: 736  ##sys#error */
t3=*((C_word*)lf[105]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[106],t2);}

/* mode in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_1978(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[104]));}

/* current-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1938(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1938r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1938r(t0,t1,t2);}}

static void f_1938r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1942,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_1942(t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_slot(t2,C_fix(1));
t5=(C_word)C_i_nullp(t4);
t6=t3;
f_1942(t6,(C_truep(t5)?(C_word)C_u_i_car(t2):C_SCHEME_TRUE));}}

/* k1940 in current-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1942(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1942,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix.scm: 719  change-directory */
t2=*((C_word*)lf[92]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1951,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 720  make-string */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(256));}}

/* k1949 in k1940 in current-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posix.scm: 723  ##sys#substring */
t3=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posix.scm: 724  posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[2],lf[44],lf[100],lf[103],C_SCHEME_END_OF_LIST);}}

/* directory? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1918(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1918,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1922,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1936,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 712  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1934 in directory? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 712  ##sys#file-info */
t2=*((C_word*)lf[102]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1920 in directory? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1767(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_1767r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1767r(t0,t1,t2);}}

static void f_1767r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1769,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1864,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1869,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec143167 */
t6=t5;
f_1869(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?144165 */
t8=t4;
f_1864(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body141146 */
t10=t3;
f_1769(t10,t1,t6,t8);}}}

/* def-spec143 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1869(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1869,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1877,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 685  current-directory */
t3=*((C_word*)lf[100]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1875 in def-spec143 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?144165 */
t2=((C_word*)t0)[3];
f_1864(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?144 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1864(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1864,NULL,3,t0,t1,t2);}
/* body141146 */
t3=((C_word*)t0)[2];
f_1769(t3,t1,t2,C_SCHEME_FALSE);}

/* body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1769(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1769,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1773,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 687  make-string */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1773,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1776,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 688  ##sys#make-pointer */
t3=*((C_word*)lf[99]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1776,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1779,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix.scm: 689  ##sys#make-pointer */
t3=*((C_word*)lf[99]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1779,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1783,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1863,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 690  ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1861 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 690  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1781 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1783,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
/* posix.scm: 692  posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[6],lf[44],lf[97],lf[98],(C_word)C_a_i_list(&a,1,((C_word*)t0)[5]));}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1797,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_1797(t6,((C_word*)t0)[6]);}}

/* loop in k1781 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1797(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1797,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1807,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 700  ##sys#substring */
t5=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1805 in loop in k1781 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1807,2,t0,t1);}
t2=(C_word)C_subchar(t1,C_fix(0));
t3=(C_word)C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_subchar(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1819,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1819(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1819(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1819(t7,C_SCHEME_FALSE);}}

/* k1817 in k1805 in loop in k1781 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1819(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1819,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix.scm: 707  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1797(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1829,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 708  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1797(t3,t2);}}

/* k1827 in k1817 in k1805 in loop in k1781 in k1777 in k1774 in k1771 in body141 in directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1829,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1746(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1746,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1761,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1765,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 678  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1763 in delete-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 678  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1759 in delete-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1761,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 679  posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[94],lf[95],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* change-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1725(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1725,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1740,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1744,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 672  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1742 in change-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 672  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1738 in change-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1740,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 673  posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[92],lf[93],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1704(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1704,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1719,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1723,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 666  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1721 in create-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 666  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1717 in create-directory in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1719,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 667  posix-error */
t3=lf[4];
f_1107(t3,((C_word*)t0)[3],lf[44],lf[90],lf[91],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* set-file-position! in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1652r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1652r(t0,t1,t2,t3,t4);}}

static void f_1652r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1659,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posix.scm: 652  ##sys#signal-hook */
t8=*((C_word*)lf[5]+1);
((C_proc7)(void*)(*((C_word*)t8+1)))(7,t8,t7,lf[88],lf[85],lf[89],t3,t2);}
else{
t8=t7;
f_1659(2,t8,C_SCHEME_UNDEFINED);}}

/* k1657 in set-file-position! in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1659,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1665,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1671,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 653  port? */
t4=*((C_word*)lf[84]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1669 in k1657 in set-file-position! in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[82]);
t4=((C_word*)t0)[4];
f_1665(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1665(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posix.scm: 657  ##sys#signal-hook */
t2=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[53],lf[85],lf[87],((C_word*)t0)[5]);}}}

/* k1663 in k1657 in set-file-position! in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1665,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 658  posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[4],lf[44],lf[85],lf[86],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}}

/* file-position in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1615(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1615,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1619,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1631,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm: 637  port? */
t5=*((C_word*)lf[84]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1629 in file-position in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1631(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[82]);
t4=((C_word*)t0)[2];
f_1619(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1619(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posix.scm: 642  ##sys#signal-hook */
t2=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[53],lf[80],lf[83],((C_word*)t0)[3]);}}}

/* k1617 in file-position in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1619,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1622,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 644  posix-error */
t3=lf[4];
f_1107(t3,t2,lf[44],lf[80],lf[81],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_1622(2,t3,C_SCHEME_UNDEFINED);}}

/* k1620 in k1617 in file-position in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1609(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1609,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1613,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 632  ##sys#stat */
f_1501(t3,t2,C_SCHEME_TRUE,lf[79]);}

/* k1611 in symbolic-link? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1603(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1603,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1607,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 627  ##sys#stat */
f_1501(t3,t2,C_SCHEME_TRUE,lf[78]);}

/* k1605 in regular-file? in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1597(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1597,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1601,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 623  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[77]);}

/* k1599 in file-permissions in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1591(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1591,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1595,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 622  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[76]);}

/* k1593 in file-owner in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1585(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1585,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1589,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 621  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[75]);}

/* k1587 in file-change-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1589,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1579(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1579,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1583,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 620  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[74]);}

/* k1581 in file-access-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1583,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1573(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1573,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1577,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 619  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[73]);}

/* k1575 in file-modification-time in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1577,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1567(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1567,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1571,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 618  ##sys#stat */
f_1501(t3,t2,C_SCHEME_FALSE,lf[72]);}

/* k1569 in file-size in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1538(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_1538r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1538r(t0,t1,t2,t3);}}

static void f_1538r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1542,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1549,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_1549(t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_slot(t3,C_fix(1));
t7=(C_word)C_i_nullp(t6);
t8=t5;
f_1549(t8,(C_truep(t7)?(C_word)C_u_i_car(t3):C_SCHEME_TRUE));}}

/* k1547 in file-stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1549(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 613  ##sys#stat */
f_1501(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[71]);}

/* k1540 in file-stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1542,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1501(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1501,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1505,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_1505(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1526,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1533,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 600  ##sys#expand-home-path */
t8=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posix.scm: 608  ##sys#signal-hook */
t6=*((C_word*)lf[5]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[53],lf[70],t2);}}}

/* k1531 in ##sys#stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 600  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1524 in ##sys#stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1505(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k1503 in ##sys#stat in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1505,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 610  posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[4],lf[44],((C_word*)t0)[3],lf[69],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1324(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1324r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1324r(t0,t1,t2,t3,t4);}}

static void f_1324r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1318(C_fix(0));
t10=f_1318(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1340,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1340(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posix.scm: 533  fd_set */
t14=t12;
f_1340(2,t14,f_1320(C_fix(0),t2));}
else{
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1485,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* for-each */
t14=*((C_word*)lf[64]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t12,t13,t2);}}}

/* a1484 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1485(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1485,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posix.scm: 540  fd_set */
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f_1320(C_fix(0),t2));}

/* k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1340(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1340,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1346,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1346(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posix.scm: 545  fd_set */
t5=t3;
f_1346(2,t5,f_1320(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1465,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[64]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,t4,((C_word*)t0)[8]);}}}

/* a1464 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1465(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1465,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posix.scm: 552  fd_set */
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f_1320(C_fix(1),t2));}

/* k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1346,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1349,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1349(t4,(C_word)C_C_select_t(t3,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1349(t4,(C_word)C_C_select(t3));}}

/* k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1349(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1349,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posix.scm: 559  posix-error */
t2=lf[4];
f_1107(t2,((C_word*)t0)[5],lf[44],lf[62],lf[63],(C_word)C_a_i_list(&a,2,((C_word*)t0)[4],((C_word*)t0)[3]));}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posix.scm: 560  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1388,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posix.scm: 565  fd_test */
t4=t3;
f_1388(t4,f_1322(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1429,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1431,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t8=*((C_word*)lf[64]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1388(t4,C_SCHEME_FALSE);}}}}

/* a1430 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1431(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1431,3,t0,t1,t2);}
t3=f_1322(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1427 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1388(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1386 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1388(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1388,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1392,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posix.scm: 571  fd_test */
t3=t2;
f_1392(t3,f_1322(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1404,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1406,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t7=*((C_word*)lf[64]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1392(t3,C_SCHEME_FALSE);}}

/* a1405 in k1386 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1406(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1406,3,t0,t1,t2);}
t3=f_1322(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1402 in k1386 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1392(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1390 in k1386 in k1347 in k1344 in k1338 in file-select in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1392(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 562  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_1322(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub65(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_set in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_1320(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub59(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_1318(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub54(C_SCHEME_UNDEFINED,t1));}

/* file-mkstemp in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1289(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1289,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1293,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix.scm: 511  ##sys#make-c-string */
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1291 in file-mkstemp in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1293,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1296,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix.scm: 513  string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k1294 in k1291 in file-mkstemp in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1296,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1299,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
/* posix.scm: 515  posix-error */
t4=lf[4];
f_1107(t4,t2,lf[44],lf[59],lf[61],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t2;
f_1299(2,t4,C_SCHEME_UNDEFINED);}}

/* k1297 in k1294 in k1291 in file-mkstemp in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1299,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1306,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posix.scm: 516  ##sys#substring */
t4=*((C_word*)lf[60]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1304 in k1297 in k1294 in k1291 in file-mkstemp in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 516  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1256(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1256r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1256r(t0,t1,t2,t3,t4);}}

static void f_1256r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1260,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t5;
f_1260(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 496  ##sys#signal-hook */
t7=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t5,lf[53],lf[55],lf[57],t3);}}

/* k1258 in file-write in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1260,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1266,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
/* posix.scm: 501  posix-error */
t7=lf[4];
f_1107(t7,t5,lf[44],lf[55],lf[56],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],t3));}
else{
t7=t5;
f_1266(2,t7,C_SCHEME_UNDEFINED);}}

/* k1264 in k1258 in file-write in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1220r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1220r(t0,t1,t2,t3,t4);}}

static void f_1220r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1224,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t6=t5;
f_1224(2,t6,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posix.scm: 484  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}}

/* k1222 in file-read in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1224,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1227,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1227(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posix.scm: 486  ##sys#signal-hook */
t4=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[53],lf[51],lf[54],t1);}}

/* k1225 in k1222 in file-read in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1227,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1230,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posix.scm: 489  posix-error */
t5=lf[4];
f_1107(t5,t3,lf[44],lf[51],lf[52],(C_word)C_a_i_list(&a,2,((C_word*)t0)[5],((C_word*)t0)[3]));}
else{
t5=t3;
f_1230(2,t5,C_SCHEME_UNDEFINED);}}

/* k1228 in k1225 in k1222 in file-read in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1230,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1208(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1208,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posix.scm: 477  posix-error */
t3=lf[4];
f_1107(t3,t1,lf[44],lf[48],lf[49],(C_word)C_a_i_list(&a,1,t2));}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-open in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1179r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1179r(t0,t1,t2,t3,t4);}}

static void f_1179r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1187,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1200,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posix.scm: 468  ##sys#expand-home-path */
t9=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k1198 in file-open in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 468  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1185 in file-open in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1187,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1190,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posix.scm: 470  posix-error */
t5=lf[4];
f_1107(t5,t3,lf[44],lf[43],lf[45],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t5=t3;
f_1190(2,t5,C_SCHEME_UNDEFINED);}}

/* k1188 in k1185 in file-open in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1124(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1124,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1130,tmp=(C_word)a,a+=2,tmp);
/* posix.scm: 384  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a1129 in yield in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1130(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1130,3,t0,t1,t2);}
t3=*((C_word*)lf[10]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1139,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posix.scm: 388  ##sys#schedule */
t6=*((C_word*)lf[11]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t1);}

/* a1138 in a1129 in yield in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1139,2,t0,t1);}
/* posix.scm: 387  return */
t2=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* posix-error in k1095 in k1092 in k1089 in k1086 in k1083 */
static void C_fcall f_1107(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1107,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1111,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posix.scm: 377  ##sys#update-errno */
t7=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1109 in posix-error in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1111,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1118,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1122,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub9(t4,t1),C_fix(0));}

/* k1120 in k1109 in posix-error in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix.scm: 378  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[6],t1);}

/* k1116 in k1109 in posix-error in k1095 in k1092 in k1089 in k1086 in k1083 */
static void f_1118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[5]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* make-nonblocking in k1095 in k1092 in k1089 in k1086 in k1083 */
static C_word C_fcall f_1099(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub3(C_SCHEME_UNDEFINED,t1));}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[415] = {
{"toplevelposix.scm",(void*)C_posix_toplevel},
{"f_1085posix.scm",(void*)f_1085},
{"f_1088posix.scm",(void*)f_1088},
{"f_1091posix.scm",(void*)f_1091},
{"f_1094posix.scm",(void*)f_1094},
{"f_1097posix.scm",(void*)f_1097},
{"f_2219posix.scm",(void*)f_2219},
{"f_4736posix.scm",(void*)f_4736},
{"f_2268posix.scm",(void*)f_2268},
{"f_2777posix.scm",(void*)f_2777},
{"f_4716posix.scm",(void*)f_4716},
{"f_4712posix.scm",(void*)f_4712},
{"f_4493posix.scm",(void*)f_4493},
{"f_4641posix.scm",(void*)f_4641},
{"f_4647posix.scm",(void*)f_4647},
{"f_4636posix.scm",(void*)f_4636},
{"f_4631posix.scm",(void*)f_4631},
{"f_4495posix.scm",(void*)f_4495},
{"f_4618posix.scm",(void*)f_4618},
{"f_4626posix.scm",(void*)f_4626},
{"f_4499posix.scm",(void*)f_4499},
{"f_4606posix.scm",(void*)f_4606},
{"f_4509posix.scm",(void*)f_4509},
{"f_4511posix.scm",(void*)f_4511},
{"f_4530posix.scm",(void*)f_4530},
{"f_4592posix.scm",(void*)f_4592},
{"f_4599posix.scm",(void*)f_4599},
{"f_4586posix.scm",(void*)f_4586},
{"f_4545posix.scm",(void*)f_4545},
{"f_4576posix.scm",(void*)f_4576},
{"f_4562posix.scm",(void*)f_4562},
{"f_4574posix.scm",(void*)f_4574},
{"f_4570posix.scm",(void*)f_4570},
{"f_4557posix.scm",(void*)f_4557},
{"f_4555posix.scm",(void*)f_4555},
{"f_4610posix.scm",(void*)f_4610},
{"f_4185posix.scm",(void*)f_4185},
{"f_4448posix.scm",(void*)f_4448},
{"f_4443posix.scm",(void*)f_4443},
{"f_4187posix.scm",(void*)f_4187},
{"f_4199posix.scm",(void*)f_4199},
{"f_4211posix.scm",(void*)f_4211},
{"f_4392posix.scm",(void*)f_4392},
{"f_4396posix.scm",(void*)f_4396},
{"f_4399posix.scm",(void*)f_4399},
{"f_4439posix.scm",(void*)f_4439},
{"f_4402posix.scm",(void*)f_4402},
{"f_4430posix.scm",(void*)f_4430},
{"f_4405posix.scm",(void*)f_4405},
{"f_4414posix.scm",(void*)f_4414},
{"f_4215posix.scm",(void*)f_4215},
{"f_4218posix.scm",(void*)f_4218},
{"f_4221posix.scm",(void*)f_4221},
{"f_4234posix.scm",(void*)f_4234},
{"f_4379posix.scm",(void*)f_4379},
{"f_4383posix.scm",(void*)f_4383},
{"f_4363posix.scm",(void*)f_4363},
{"f_4347posix.scm",(void*)f_4347},
{"f_4351posix.scm",(void*)f_4351},
{"f_4278posix.scm",(void*)f_4278},
{"f_4334posix.scm",(void*)f_4334},
{"f_4338posix.scm",(void*)f_4338},
{"f_4284posix.scm",(void*)f_4284},
{"f_4293posix.scm",(void*)f_4293},
{"f_4325posix.scm",(void*)f_4325},
{"f_4309posix.scm",(void*)f_4309},
{"f_4282posix.scm",(void*)f_4282},
{"f_4236posix.scm",(void*)f_4236},
{"f_4250posix.scm",(void*)f_4250},
{"f_4266posix.scm",(void*)f_4266},
{"f_4269posix.scm",(void*)f_4269},
{"f_4246posix.scm",(void*)f_4246},
{"f_4205posix.scm",(void*)f_4205},
{"f_4193posix.scm",(void*)f_4193},
{"f_4165posix.scm",(void*)f_4165},
{"f_4177posix.scm",(void*)f_4177},
{"f_4171posix.scm",(void*)f_4171},
{"f_4119posix.scm",(void*)f_4119},
{"f_4126posix.scm",(void*)f_4126},
{"f_4141posix.scm",(void*)f_4141},
{"f_4098posix.scm",(void*)f_4098},
{"f_4095posix.scm",(void*)f_4095},
{"f_4092posix.scm",(void*)f_4092},
{"f_4089posix.scm",(void*)f_4089},
{"f_4019posix.scm",(void*)f_4019},
{"f_3855posix.scm",(void*)f_3855},
{"f_3974posix.scm",(void*)f_3974},
{"f_3969posix.scm",(void*)f_3969},
{"f_3857posix.scm",(void*)f_3857},
{"f_3861posix.scm",(void*)f_3861},
{"f_3869posix.scm",(void*)f_3869},
{"f_3912posix.scm",(void*)f_3912},
{"f_3882posix.scm",(void*)f_3882},
{"f_3907posix.scm",(void*)f_3907},
{"f_3885posix.scm",(void*)f_3885},
{"f_3847posix.scm",(void*)f_3847},
{"f_3839posix.scm",(void*)f_3839},
{"f_3801posix.scm",(void*)f_3801},
{"f_3823posix.scm",(void*)f_3823},
{"f_3827posix.scm",(void*)f_3827},
{"f_3695posix.scm",(void*)f_3695},
{"f_3701posix.scm",(void*)f_3701},
{"f_3722posix.scm",(void*)f_3722},
{"f_3793posix.scm",(void*)f_3793},
{"f_3726posix.scm",(void*)f_3726},
{"f_3733posix.scm",(void*)f_3733},
{"f_3735posix.scm",(void*)f_3735},
{"f_3752posix.scm",(void*)f_3752},
{"f_3762posix.scm",(void*)f_3762},
{"f_3766posix.scm",(void*)f_3766},
{"f_3716posix.scm",(void*)f_3716},
{"f_3683posix.scm",(void*)f_3683},
{"f_3687posix.scm",(void*)f_3687},
{"f_3690posix.scm",(void*)f_3690},
{"f_3656posix.scm",(void*)f_3656},
{"f_3660posix.scm",(void*)f_3660},
{"f_3635posix.scm",(void*)f_3635},
{"f_3639posix.scm",(void*)f_3639},
{"f_3582posix.scm",(void*)f_3582},
{"f_3589posix.scm",(void*)f_3589},
{"f_3579posix.scm",(void*)f_3579},
{"f_3560posix.scm",(void*)f_3560},
{"f_3564posix.scm",(void*)f_3564},
{"f_3552posix.scm",(void*)f_3552},
{"f_3524posix.scm",(void*)f_3524},
{"f_3531posix.scm",(void*)f_3531},
{"f_3496posix.scm",(void*)f_3496},
{"f_3503posix.scm",(void*)f_3503},
{"f_3468posix.scm",(void*)f_3468},
{"f_3475posix.scm",(void*)f_3475},
{"f_3478posix.scm",(void*)f_3478},
{"f_3481posix.scm",(void*)f_3481},
{"f_3451posix.scm",(void*)f_3451},
{"f_3455posix.scm",(void*)f_3455},
{"f_3458posix.scm",(void*)f_3458},
{"f_3440posix.scm",(void*)f_3440},
{"f_3434posix.scm",(void*)f_3434},
{"f_3428posix.scm",(void*)f_3428},
{"f_3422posix.scm",(void*)f_3422},
{"f_3390posix.scm",(void*)f_3390},
{"f_3332posix.scm",(void*)f_3332},
{"f_3336posix.scm",(void*)f_3336},
{"f_3342posix.scm",(void*)f_3342},
{"f_3361posix.scm",(void*)f_3361},
{"f_3348posix.scm",(void*)f_3348},
{"f_3249posix.scm",(void*)f_3249},
{"f_3255posix.scm",(void*)f_3255},
{"f_3259posix.scm",(void*)f_3259},
{"f_3267posix.scm",(void*)f_3267},
{"f_3293posix.scm",(void*)f_3293},
{"f_3297posix.scm",(void*)f_3297},
{"f_3285posix.scm",(void*)f_3285},
{"f_3237posix.scm",(void*)f_3237},
{"f_3242posix.scm",(void*)f_3242},
{"f_3226posix.scm",(void*)f_3226},
{"f_3231posix.scm",(void*)f_3231},
{"f_3235posix.scm",(void*)f_3235},
{"f_3203posix.scm",(void*)f_3203},
{"f_3224posix.scm",(void*)f_3224},
{"f_3207posix.scm",(void*)f_3207},
{"f_3166posix.scm",(void*)f_3166},
{"f_3170posix.scm",(void*)f_3170},
{"f_3188posix.scm",(void*)f_3188},
{"f_3184posix.scm",(void*)f_3184},
{"f_3141posix.scm",(void*)f_3141},
{"f_3119posix.scm",(void*)f_3119},
{"f_3123posix.scm",(void*)f_3123},
{"f_3104posix.scm",(void*)f_3104},
{"f_3108posix.scm",(void*)f_3108},
{"f_3089posix.scm",(void*)f_3089},
{"f_3093posix.scm",(void*)f_3093},
{"f_3071posix.scm",(void*)f_3071},
{"f_3009posix.scm",(void*)f_3009},
{"f_3028posix.scm",(void*)f_3028},
{"f_2973posix.scm",(void*)f_2973},
{"f_2998posix.scm",(void*)f_2998},
{"f_2994posix.scm",(void*)f_2994},
{"f_2987posix.scm",(void*)f_2987},
{"f_2952posix.scm",(void*)f_2952},
{"f_2956posix.scm",(void*)f_2956},
{"f_2959posix.scm",(void*)f_2959},
{"f_2910posix.scm",(void*)f_2910},
{"f_2946posix.scm",(void*)f_2946},
{"f_2929posix.scm",(void*)f_2929},
{"f_2899posix.scm",(void*)f_2899},
{"f_2908posix.scm",(void*)f_2908},
{"f_2888posix.scm",(void*)f_2888},
{"f_2897posix.scm",(void*)f_2897},
{"f_2873posix.scm",(void*)f_2873},
{"f_2886posix.scm",(void*)f_2886},
{"f_2836posix.scm",(void*)f_2836},
{"f_2844posix.scm",(void*)f_2844},
{"f_2817posix.scm",(void*)f_2817},
{"f_2806posix.scm",(void*)f_2806},
{"f_2810posix.scm",(void*)f_2810},
{"f_2778posix.scm",(void*)f_2778},
{"f_2799posix.scm",(void*)f_2799},
{"f_2783posix.scm",(void*)f_2783},
{"f_2786posix.scm",(void*)f_2786},
{"f_2746posix.scm",(void*)f_2746},
{"f_2773posix.scm",(void*)f_2773},
{"f_2761posix.scm",(void*)f_2761},
{"f_2769posix.scm",(void*)f_2769},
{"f_2765posix.scm",(void*)f_2765},
{"f_2731posix.scm",(void*)f_2731},
{"f_2741posix.scm",(void*)f_2741},
{"f_2716posix.scm",(void*)f_2716},
{"f_2726posix.scm",(void*)f_2726},
{"f_2720posix.scm",(void*)f_2720},
{"f_2701posix.scm",(void*)f_2701},
{"f_2711posix.scm",(void*)f_2711},
{"f_2705posix.scm",(void*)f_2705},
{"f_2695posix.scm",(void*)f_2695},
{"f_2689posix.scm",(void*)f_2689},
{"f_2683posix.scm",(void*)f_2683},
{"f_2662posix.scm",(void*)f_2662},
{"f_2681posix.scm",(void*)f_2681},
{"f_2677posix.scm",(void*)f_2677},
{"f_2669posix.scm",(void*)f_2669},
{"f_2647posix.scm",(void*)f_2647},
{"f_2657posix.scm",(void*)f_2657},
{"f_2632posix.scm",(void*)f_2632},
{"f_2642posix.scm",(void*)f_2642},
{"f_2629posix.scm",(void*)f_2629},
{"f_2626posix.scm",(void*)f_2626},
{"f_2623posix.scm",(void*)f_2623},
{"f_2620posix.scm",(void*)f_2620},
{"f_2599posix.scm",(void*)f_2599},
{"f_2618posix.scm",(void*)f_2618},
{"f_2614posix.scm",(void*)f_2614},
{"f_2578posix.scm",(void*)f_2578},
{"f_2597posix.scm",(void*)f_2597},
{"f_2593posix.scm",(void*)f_2593},
{"f_2536posix.scm",(void*)f_2536},
{"f_2532posix.scm",(void*)f_2532},
{"f_2546posix.scm",(void*)f_2546},
{"f_2473posix.scm",(void*)f_2473},
{"f_2477posix.scm",(void*)f_2477},
{"f_2482posix.scm",(void*)f_2482},
{"f_2498posix.scm",(void*)f_2498},
{"f_2410posix.scm",(void*)f_2410},
{"f_2468posix.scm",(void*)f_2468},
{"f_2414posix.scm",(void*)f_2414},
{"f_2417posix.scm",(void*)f_2417},
{"f_2449posix.scm",(void*)f_2449},
{"f_2420posix.scm",(void*)f_2420},
{"f_2425posix.scm",(void*)f_2425},
{"f_2439posix.scm",(void*)f_2439},
{"f_2407posix.scm",(void*)f_2407},
{"f_2353posix.scm",(void*)f_2353},
{"f_2402posix.scm",(void*)f_2402},
{"f_2357posix.scm",(void*)f_2357},
{"f_2367posix.scm",(void*)f_2367},
{"f_2371posix.scm",(void*)f_2371},
{"f_2377posix.scm",(void*)f_2377},
{"f_2381posix.scm",(void*)f_2381},
{"f_2391posix.scm",(void*)f_2391},
{"f_2375posix.scm",(void*)f_2375},
{"f_2308posix.scm",(void*)f_2308},
{"f_2345posix.scm",(void*)f_2345},
{"f_2312posix.scm",(void*)f_2312},
{"f_2322posix.scm",(void*)f_2322},
{"f_2326posix.scm",(void*)f_2326},
{"f_2330posix.scm",(void*)f_2330},
{"f_2334posix.scm",(void*)f_2334},
{"f_2338posix.scm",(void*)f_2338},
{"f_2270posix.scm",(void*)f_2270},
{"f_2303posix.scm",(void*)f_2303},
{"f_2274posix.scm",(void*)f_2274},
{"f_2281posix.scm",(void*)f_2281},
{"f_2285posix.scm",(void*)f_2285},
{"f_2289posix.scm",(void*)f_2289},
{"f_2293posix.scm",(void*)f_2293},
{"f_2297posix.scm",(void*)f_2297},
{"f_2249posix.scm",(void*)f_2249},
{"f_2264posix.scm",(void*)f_2264},
{"f_2253posix.scm",(void*)f_2253},
{"f_2231posix.scm",(void*)f_2231},
{"f_2241posix.scm",(void*)f_2241},
{"f_2221posix.scm",(void*)f_2221},
{"f_2178posix.scm",(void*)f_2178},
{"f_2182posix.scm",(void*)f_2182},
{"f_2158posix.scm",(void*)f_2158},
{"f_2162posix.scm",(void*)f_2162},
{"f_2168posix.scm",(void*)f_2168},
{"f_2172posix.scm",(void*)f_2172},
{"f_2138posix.scm",(void*)f_2138},
{"f_2142posix.scm",(void*)f_2142},
{"f_2148posix.scm",(void*)f_2148},
{"f_2152posix.scm",(void*)f_2152},
{"f_2114posix.scm",(void*)f_2114},
{"f_2118posix.scm",(void*)f_2118},
{"f_2129posix.scm",(void*)f_2129},
{"f_2133posix.scm",(void*)f_2133},
{"f_2123posix.scm",(void*)f_2123},
{"f_2090posix.scm",(void*)f_2090},
{"f_2094posix.scm",(void*)f_2094},
{"f_2105posix.scm",(void*)f_2105},
{"f_2109posix.scm",(void*)f_2109},
{"f_2099posix.scm",(void*)f_2099},
{"f_2077posix.scm",(void*)f_2077},
{"f_2081posix.scm",(void*)f_2081},
{"f_2044posix.scm",(void*)f_2044},
{"f_2072posix.scm",(void*)f_2072},
{"f_2062posix.scm",(void*)f_2062},
{"f_2055posix.scm",(void*)f_2055},
{"f_2011posix.scm",(void*)f_2011},
{"f_2039posix.scm",(void*)f_2039},
{"f_2029posix.scm",(void*)f_2029},
{"f_2022posix.scm",(void*)f_2022},
{"f_1996posix.scm",(void*)f_1996},
{"f_2009posix.scm",(void*)f_2009},
{"f_1990posix.scm",(void*)f_1990},
{"f_1978posix.scm",(void*)f_1978},
{"f_1938posix.scm",(void*)f_1938},
{"f_1942posix.scm",(void*)f_1942},
{"f_1951posix.scm",(void*)f_1951},
{"f_1918posix.scm",(void*)f_1918},
{"f_1936posix.scm",(void*)f_1936},
{"f_1922posix.scm",(void*)f_1922},
{"f_1767posix.scm",(void*)f_1767},
{"f_1869posix.scm",(void*)f_1869},
{"f_1877posix.scm",(void*)f_1877},
{"f_1864posix.scm",(void*)f_1864},
{"f_1769posix.scm",(void*)f_1769},
{"f_1773posix.scm",(void*)f_1773},
{"f_1776posix.scm",(void*)f_1776},
{"f_1779posix.scm",(void*)f_1779},
{"f_1863posix.scm",(void*)f_1863},
{"f_1783posix.scm",(void*)f_1783},
{"f_1797posix.scm",(void*)f_1797},
{"f_1807posix.scm",(void*)f_1807},
{"f_1819posix.scm",(void*)f_1819},
{"f_1829posix.scm",(void*)f_1829},
{"f_1746posix.scm",(void*)f_1746},
{"f_1765posix.scm",(void*)f_1765},
{"f_1761posix.scm",(void*)f_1761},
{"f_1725posix.scm",(void*)f_1725},
{"f_1744posix.scm",(void*)f_1744},
{"f_1740posix.scm",(void*)f_1740},
{"f_1704posix.scm",(void*)f_1704},
{"f_1723posix.scm",(void*)f_1723},
{"f_1719posix.scm",(void*)f_1719},
{"f_1652posix.scm",(void*)f_1652},
{"f_1659posix.scm",(void*)f_1659},
{"f_1671posix.scm",(void*)f_1671},
{"f_1665posix.scm",(void*)f_1665},
{"f_1615posix.scm",(void*)f_1615},
{"f_1631posix.scm",(void*)f_1631},
{"f_1619posix.scm",(void*)f_1619},
{"f_1622posix.scm",(void*)f_1622},
{"f_1609posix.scm",(void*)f_1609},
{"f_1613posix.scm",(void*)f_1613},
{"f_1603posix.scm",(void*)f_1603},
{"f_1607posix.scm",(void*)f_1607},
{"f_1597posix.scm",(void*)f_1597},
{"f_1601posix.scm",(void*)f_1601},
{"f_1591posix.scm",(void*)f_1591},
{"f_1595posix.scm",(void*)f_1595},
{"f_1585posix.scm",(void*)f_1585},
{"f_1589posix.scm",(void*)f_1589},
{"f_1579posix.scm",(void*)f_1579},
{"f_1583posix.scm",(void*)f_1583},
{"f_1573posix.scm",(void*)f_1573},
{"f_1577posix.scm",(void*)f_1577},
{"f_1567posix.scm",(void*)f_1567},
{"f_1571posix.scm",(void*)f_1571},
{"f_1538posix.scm",(void*)f_1538},
{"f_1549posix.scm",(void*)f_1549},
{"f_1542posix.scm",(void*)f_1542},
{"f_1501posix.scm",(void*)f_1501},
{"f_1533posix.scm",(void*)f_1533},
{"f_1526posix.scm",(void*)f_1526},
{"f_1505posix.scm",(void*)f_1505},
{"f_1324posix.scm",(void*)f_1324},
{"f_1485posix.scm",(void*)f_1485},
{"f_1340posix.scm",(void*)f_1340},
{"f_1465posix.scm",(void*)f_1465},
{"f_1346posix.scm",(void*)f_1346},
{"f_1349posix.scm",(void*)f_1349},
{"f_1431posix.scm",(void*)f_1431},
{"f_1429posix.scm",(void*)f_1429},
{"f_1388posix.scm",(void*)f_1388},
{"f_1406posix.scm",(void*)f_1406},
{"f_1404posix.scm",(void*)f_1404},
{"f_1392posix.scm",(void*)f_1392},
{"f_1322posix.scm",(void*)f_1322},
{"f_1320posix.scm",(void*)f_1320},
{"f_1318posix.scm",(void*)f_1318},
{"f_1289posix.scm",(void*)f_1289},
{"f_1293posix.scm",(void*)f_1293},
{"f_1296posix.scm",(void*)f_1296},
{"f_1299posix.scm",(void*)f_1299},
{"f_1306posix.scm",(void*)f_1306},
{"f_1256posix.scm",(void*)f_1256},
{"f_1260posix.scm",(void*)f_1260},
{"f_1266posix.scm",(void*)f_1266},
{"f_1220posix.scm",(void*)f_1220},
{"f_1224posix.scm",(void*)f_1224},
{"f_1227posix.scm",(void*)f_1227},
{"f_1230posix.scm",(void*)f_1230},
{"f_1208posix.scm",(void*)f_1208},
{"f_1179posix.scm",(void*)f_1179},
{"f_1200posix.scm",(void*)f_1200},
{"f_1187posix.scm",(void*)f_1187},
{"f_1190posix.scm",(void*)f_1190},
{"f_1124posix.scm",(void*)f_1124},
{"f_1130posix.scm",(void*)f_1130},
{"f_1139posix.scm",(void*)f_1139},
{"f_1107posix.scm",(void*)f_1107},
{"f_1111posix.scm",(void*)f_1111},
{"f_1122posix.scm",(void*)f_1122},
{"f_1118posix.scm",(void*)f_1118},
{"f_1099posix.scm",(void*)f_1099},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
