/* $Id: deqp.c,v 1.5 2004/02/08 15:23:31 relson Exp $ */

#include "common.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>		/* for SEEK_*** for SunOS 4.1.x */

#include "qp.h"

static void die(void) __attribute__((noreturn));
static void die(void) {
    perror("deqp");
    exit(EXIT_FAILURE);
}

int main(void) {
    size_t size;
    word_t *w;

    if (fseek(stdin, 0, SEEK_END)) die();
    size = ftell(stdin);
    if (fseek(stdin, 0, SEEK_SET)) die();
    w = word_new(NULL, size);
    if (fread(w->text, 1, w->leng, stdin) != w->leng) die();
    size = qp_decode(w);
    if (fwrite(w->text, 1, size, stdout) != size) die();
    word_free(w);
    if (fflush(stdout)) die();
    if (fclose(stdout)) die();
    return EXIT_SUCCESS;
}
