/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2004-2005  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation;
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
 *  CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
 *  COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
 *  SOFTWARE IS DISCLAIMED.
 *
 *
 *  $Id: oui.c,v 1.2 2005/04/18 12:19:26 holtmann Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include "oui.h"

/* http://standards.ieee.org/regauth/oui/oui.txt */

#define OUIFILE "/usr/share/misc/oui.txt"

char *ouitocomp(const char *oui)
{
	struct stat st;
	char *str, *map, *off, *end;
	int fd;


	fd = open(OUIFILE, O_RDONLY);
	if (fd < 0)
		return NULL;

	if (fstat(fd, &st) < 0) {
		close(fd);
		return NULL;
	}

	str = malloc(128);
	if (!str) {
		close(fd);
		return NULL;
	}

	memset(str, 0, 128);

	map = mmap(0, st.st_size, PROT_READ, MAP_SHARED, fd, 0);
	if (map == MAP_FAILED) {
		free(str);
		close(fd);
		return NULL;
	}

	off = strstr(map, oui);
	if (off) {
		off += 18;
		end = strpbrk(off, "\r\n");
		strncpy(str, off, end - off);
	} else {
		free(str);
		str = NULL;
	}

	munmap(map, st.st_size);

	close(fd);

	return str;
}

int oui2comp(const char *oui, char *comp, size_t size)
{
	char *tmp;

	tmp = ouitocomp(oui);
	if (!tmp)
		return -1;

	snprintf(comp, size, "%s", tmp);

	free(tmp);

	return 0;
}
